package net.earlystage.mixin;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.earlystage.init.RecipeInit;
import net.earlystage.misc.ExtraBlastingRecipe;
import net.earlystage.misc.ExtraBlastingRecipeInput;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_8786;

@Mixin(class_2609.class)
public abstract class AbstractFurnaceBlockEntityMixin extends class_2624 {

    @Shadow
    int cookTime;
    @Shadow
    int cookTimeTotal;
    @Shadow
    @Mutable
    @Final
    private Object2IntOpenHashMap<class_2960> recipesUsed;
    @Shadow
    protected class_2371<class_1799> inventory;

    public AbstractFurnaceBlockEntityMixin(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @ModifyVariable(method = "tick", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/block/entity/AbstractFurnaceBlockEntity;getMaxCountPerStack()I"))
    private static class_8786<?> tickMixin(class_8786<?> original, class_1937 world, class_2338 pos, class_2680 state, class_2609 blockEntity) {
        if (blockEntity.method_11017().equals(class_2591.field_16415) && !blockEntity.method_5438(3).method_7960()) {
            class_8786<ExtraBlastingRecipe> extraBlastingRecipe = world.method_8433()
                    .method_8132(RecipeInit.EXTRA_BLASTING, new ExtraBlastingRecipeInput(blockEntity.method_5438(0), blockEntity.method_5438(3)), world).orElse(null);
            return extraBlastingRecipe;
        }
        return original;
    }

    @Inject(method = "getCookTime", at = @At("HEAD"), cancellable = true)
    private static void getCookTimeMixin(class_1937 world, class_2609 furnace, CallbackInfoReturnable<Integer> info) {
        if (furnace.method_11017().equals(class_2591.field_16415)) {
            class_8786<ExtraBlastingRecipe> recipe = world.method_8433().method_8132(RecipeInit.EXTRA_BLASTING, new ExtraBlastingRecipeInput(furnace.method_5438(0), furnace.method_5438(3)), world)
                    .orElse(null);
            if (recipe != null) {
                info.setReturnValue(recipe.comp_1933().getCookTime());
            }
        }
    }

    @Inject(method = "craftRecipe", at = @At("TAIL"))
    private static void craftRecipeMixin(class_5455 registryManager, @Nullable class_8786<?> recipe, class_2371<class_1799> slots, int count, CallbackInfoReturnable<Boolean> info) {
        if (recipe != null && !recipe.comp_1933().method_31584() && recipe.comp_1933().method_17716().equals(RecipeInit.EXTRA_BLASTING)) {
            slots.get(3).method_7934(recipe.comp_1933().method_8117().get(1).method_8105()[0].method_7947());
            if (recipe.comp_1933().method_8117().get(0).method_8105()[0].method_7947() > 1) {
                slots.get(0).method_7934(recipe.comp_1933().method_8117().get(0).method_8105()[0].method_7947() - 1);
            }
        }
    }

    @Inject(method = "setStack", at = @At("TAIL"))
    private void setStackMixin(int slot, class_1799 stack, CallbackInfo info) {
        if (this.method_11017().equals(class_2591.field_16415) && slot == 3 && !stack.method_7960() && !class_1799.method_31577(this.inventory.get(slot), stack)) {
            this.cookTimeTotal = getCookTime(this.field_11863, (class_2609) (Object) this);
            this.cookTime = 0;
            this.method_5431();
        }
    }

    @Inject(method = "getRecipesUsedAndDropExperience", at = @At("HEAD"), cancellable = true)
    private void getRecipesUsedAndDropExperienceMixin(class_3218 world, class_243 pos, CallbackInfoReturnable<List<class_8786<?>>> info) {
        if (this.method_11017().equals(class_2591.field_16415)) {
            ArrayList<class_8786<?>> blastFurnaceExtraRecipes = Lists.newArrayList();
            for (Object2IntMap.Entry<class_2960> entry : this.recipesUsed.object2IntEntrySet()) {
                world.method_8433().method_8130(entry.getKey()).ifPresent(recipe -> {
                    blastFurnaceExtraRecipes.add(recipe);
                    if (recipe.comp_1933() instanceof ExtraBlastingRecipe extraBlastingRecipe) {
                        dropExperience(world, pos, entry.getIntValue(), extraBlastingRecipe.getExperience());
                    } else {
                        dropExperience(world, pos, entry.getIntValue(), ((class_1874) recipe.comp_1933()).method_8171());
                    }
                });
            }
            info.setReturnValue(blastFurnaceExtraRecipes);
        }
    }

    @Shadow
    private static void dropExperience(class_3218 world, class_243 pos, int multiplier, float experience) {
    }

    @Shadow
    private static int getCookTime(class_1937 world, class_2609 furnace) {
        return 0;
    }
}
