package net.earlystage.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import net.earlystage.init.ConfigInit;
import net.earlystage.init.ItemInit;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3532;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "dropInventory", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z"), cancellable = true)
    protected void dropInventoryMixin(CallbackInfo info) {
        if (!this.method_37908().method_8608() && !((class_1657) (Object) this).method_7337() && ConfigInit.CONFIG.beginnerDeathCount != 0
                && ((class_3222) (Object) this).method_14248().method_15025(class_3468.field_15419.method_14956(class_3468.field_15421)) < ConfigInit.CONFIG.beginnerDeathCount) {
            info.cancel();
        }
    }

    // RemoveOffhandItemTask and BindingCurse not done by my mixins for the shield
    @Inject(method = "damageShield", at = @At("HEAD"), cancellable = true)
    protected void damageShieldMixin(float amount, CallbackInfo info) {
        if (this.field_6277.method_31574(ItemInit.WOODEN_SHIELD)) {
            if (!this.method_37908().method_8608()) {
                this.incrementStat(class_3468.field_15372.method_14956(this.field_6277.method_7909()));
            }
            if (amount >= 3.0f) {
                int i = 1 + class_3532.method_15375(amount);
                class_1268 hand = this.method_6058();
                this.field_6277.method_7970(i, this, class_1309.method_56079(hand));
                if (this.field_6277.method_7960()) {
                    if (hand == class_1268.field_5808) {
                        this.method_5673(class_1304.field_6173, class_1799.field_8037);
                    } else {
                        this.method_5673(class_1304.field_6171, class_1799.field_8037);
                    }
                    this.field_6277 = class_1799.field_8037;
                    this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
                }
            }
            info.cancel();
        }
    }

    @Inject(method = "disableShield", at = @At("TAIL"))
    private void disableShieldMixin(CallbackInfo info) {
        this.getItemCooldownManager().method_7906(ItemInit.WOODEN_SHIELD, 100);
    }

    @Shadow
    public void incrementStat(class_3445<?> stat) {
    }

    @Shadow
    public class_1796 getItemCooldownManager() {
        return null;
    }

}
