package net.earlystage.mixin;

import com.mojang.authlib.GameProfile;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import net.earlystage.init.ConfigInit;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3468;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 {

    @Shadow
    @Mutable
    @Final
    private class_3442 statHandler;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method = "copyFrom", at = @At(value = "FIELD", target = "Lnet/minecraft/server/network/ServerPlayerEntity;enchantmentTableSeed:I", ordinal = 0))
    private void copyFromMixin(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        if (ConfigInit.CONFIG.beginnerDeathCount != 0 && !this.method_37908().method_8450().method_8355(class_1928.field_19389) && !oldPlayer.method_7325()
                && statHandler.method_15025(class_3468.field_15419.method_14956(class_3468.field_15421)) <= ConfigInit.CONFIG.beginnerDeathCount) {
            this.method_31548().method_7377(oldPlayer.method_31548());
            this.field_7520 = oldPlayer.field_7520;
            this.field_7495 = oldPlayer.field_7495;
            this.field_7510 = oldPlayer.field_7510;
            this.method_7320(oldPlayer.method_7272());
        }
    }

}
