package net.earlystage.mixin;

import net.earlystage.init.ItemInit;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1472.class)
public abstract class SheepEntityMixin extends class_1429 {

    public SheepEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "interactMob", at = @At("HEAD"), cancellable = true)
    private void interactMobMixin(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(ItemInit.STONE_SHEARS)) {
            if (!this.method_37908().method_8608() && this.isShearable()) {
                this.sheared(class_3419.field_15248);
                this.method_32875(class_5712.field_28730, player);
                itemStack.method_7970(1, player, class_1472.method_56079(hand));
                info.setReturnValue(class_1269.field_5812);
            }
        }
    }

    @Shadow
    public abstract void sheared(class_3419 shearedSoundCategory);

    @Shadow
    public abstract boolean isShearable();

}
