package net.earlystage.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import net.earlystage.block.FlintBlock;
import net.earlystage.block.RockBlock;
import net.earlystage.init.BlockInit;
import net.minecraft.class_1269;
import net.minecraft.class_1821;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

@Mixin(class_1821.class)
public class ShovelItemMixin {

    @Inject(method = "useOnBlock", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;", ordinal = 0), cancellable = true, locals = LocalCapture.CAPTURE_FAILSOFT)
    private void useOnBlockMixin(class_1838 context, CallbackInfoReturnable<class_1269> info, class_1937 world, class_2338 blockPos, class_2680 blockState) {
        if (blockState.method_27852(BlockInit.ROCK) || blockState.method_27852(BlockInit.FLINT)) {
            if (!world.method_8608()) {
                if (blockState.method_27852(BlockInit.ROCK)) {
                    ((RockBlock) blockState.method_26204()).cycleState(blockState, world, blockPos);
                } else {
                    ((FlintBlock) blockState.method_26204()).cycleState(blockState, world, blockPos);
                }
            }
            info.setReturnValue(class_1269.method_29236(world.method_8608()));
        }
    }

}
