package dev.overgrown.sync.factory.action.bientity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.factory.power.type.EntitySetPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_3545;

public class AddToEntitySetAction {

    public static void action(SerializableData.Instance data, class_3545<class_1297, class_1297> actorAndTarget) {

        Integer timeLimit = data.get("time_limit");
        if (timeLimit != null && timeLimit <= 0) {
            // Handle invalid time_limit (e.g., log error, throw exception)
            return;
        }

        PowerHolderComponent component = PowerHolderComponent.KEY.getNullable(actorAndTarget.method_15442());
        PowerType<?> powerType = data.get("set");

        if (component == null || powerType == null || !(component.getPower(powerType) instanceof EntitySetPower entitySetPower)) {
            return;
        }

        if (entitySetPower.add(actorAndTarget.method_15441(), data.get("time_limit"))) {
            PowerHolderComponent.syncPower(actorAndTarget.method_15442(), powerType);
        }

        if (entitySetPower.add(actorAndTarget.method_15441(), timeLimit)) {
            PowerHolderComponent.syncPower(actorAndTarget.method_15442(), powerType);
        }

    }

    public static ActionFactory<class_3545<class_1297, class_1297>> getFactory() {
        return new ActionFactory<>(
                Sync.identifier("add_to_entity_set"),
                new SerializableData()
                        .add("set", ApoliDataTypes.POWER_TYPE)
                        .add("time_limit", SerializableDataTypes.INT, null),
                AddToEntitySetAction::action
        );
    }
}