package dev.overgrown.sync.factory.action.bientity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.factory.power.type.EntitySetPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import net.minecraft.class_1297;
import net.minecraft.class_3545;

public class RemoveFromEntitySetAction {

    public static void action(SerializableData.Instance data, class_3545<class_1297, class_1297> actorAndTarget) {

        PowerHolderComponent component = PowerHolderComponent.KEY.getNullable(actorAndTarget.method_15442());
        PowerType<?> powerType = data.get("set");

        if (component == null || powerType == null || !(component.getPower(powerType) instanceof EntitySetPower entitySetPower)) {
            return;
        }

        if (entitySetPower.remove(actorAndTarget.method_15441())) {
            PowerHolderComponent.syncPower(actorAndTarget.method_15442(), powerType);
        }

    }

    public static ActionFactory<class_3545<class_1297, class_1297>> getFactory() {
        return new ActionFactory<>(
                Sync.identifier("remove_from_entity_set"),
                new SerializableData()
                        .add("set", ApoliDataTypes.POWER_TYPE),
                RemoveFromEntitySetAction::action
        );
    }
}