package dev.overgrown.sync.factory.action.block;

import dev.overgrown.sync.Sync;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import org.apache.commons.lang3.tuple.Triple;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;

public class SpawnEntityBlockAction {

    public static void action(SerializableData.Instance data, Triple<class_1937, class_2338, class_2350> triple) {
        class_1937 world = triple.getLeft();
        class_2338 pos = triple.getMiddle();

        if (!world.method_8608()) {
            class_1299<?> entityType = data.get("entity_type");
            class_2487 nbt = data.get("tag");

            Optional<class_1297> optionalEntity = MiscUtil.getEntityWithPassengers(
                    world, entityType, nbt, class_243.method_24953(pos), 0.0f, 0.0f
            );

            if (optionalEntity.isPresent()) {
                class_1297 entity = optionalEntity.get();
                world.method_8649(entity);

                if (data.isPresent("entity_action")) {
                    Consumer<class_1297> entityAction = data.get("entity_action");
                    entityAction.accept(entity);
                }
            }
        }
    }

    public static ActionFactory<Triple<class_1937, class_2338, class_2350>> getFactory() {
        return new ActionFactory<>(
                Sync.identifier("spawn_entity"),
                new SerializableData()
                        .add("entity_type", SerializableDataTypes.ENTITY_TYPE)
                        .add("tag", SerializableDataTypes.NBT, null)
                        .add("entity_action", ApoliDataTypes.ENTITY_ACTION, null),
                SpawnEntityBlockAction::action
        );
    }
}