package dev.overgrown.sync.factory.action.entity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.factory.power.type.EntitySetPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3545;

public class ActionOnEntitySetAction {

    public static void action(SerializableData.Instance data, class_1297 entity) {

        PowerHolderComponent component = PowerHolderComponent.KEY.maybeGet(entity).orElse(null);
        PowerType<?> powerType = data.get("set");

        if (component == null || powerType == null || !(component.getPower(powerType) instanceof EntitySetPower entitySetPower)) {
            return;
        }

        Consumer<class_3545<class_1297, class_1297>> biEntityAction = data.get("bientity_action");
        Predicate<class_3545<class_1297, class_1297>> biEntityCondition = data.get("bientity_condition");

        List<UUID> uuids = new LinkedList<>(entitySetPower.getIterationSet());
        if (data.getBoolean("reverse")) {
            Collections.reverse(uuids);
        }

        int limit = data.get("limit");
        int processedUuids = 0;

        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }

        for (UUID uuid : uuids) {

            class_1297 entityFromSet = entitySetPower.getEntity(uuid);
            class_3545<class_1297, class_1297> entityPair = new class_3545<>(entity, entityFromSet);

            if (biEntityCondition == null || biEntityCondition.test(entityPair)) {
                biEntityAction.accept(entityPair);
                processedUuids++;
            }

            if (processedUuids >= limit) {
                break;
            }

        }

    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory<>(
                Sync.identifier("action_on_entity_set"),
                new SerializableData()
                        .add("set", ApoliDataTypes.POWER_TYPE)
                        .add("bientity_action", ApoliDataTypes.BIENTITY_ACTION)
                        .add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null)
                        .add("limit", SerializableDataTypes.INT, 0)
                        .add("reverse", SerializableDataTypes.BOOLEAN, false),
                ActionOnEntitySetAction::action
        );
    }
}