package dev.overgrown.sync.factory.action.entity;

import dev.overgrown.sync.Sync;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2694;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class RandomTeleportAction {

    public static void action(SerializableData.Instance data, class_1297 entity) {

        if (!(entity.method_37908() instanceof class_3218 serverWorld)) {
            return;
        }

        Predicate<class_2694> landingBlockCondition = data.isPresent("landing_block_condition") ? data.get("landing_block_condition")
                : cachedBlockPosition -> cachedBlockPosition.method_11681().method_26212(cachedBlockPosition.method_11679(), cachedBlockPosition.method_11683());
        Predicate<class_1297> landingCondition = data.isPresent("landing_condition") ? data.get("landing_condition")
                : _entity -> serverWorld.method_17892(_entity) && !serverWorld.method_22345(_entity.method_5829());

        class_2902.class_2903 heightmap = data.get("heightmap");
        class_5819 random = class_5819.method_43047();
        class_243 landingOffset = data.get("landing_offset");

        boolean loadedChunksOnly = data.getBoolean("loaded_chunks_only");
        boolean succeeded = false;

        int attempts = data.getInt("attempts");

        double areaWidth = data.getDouble("area_width") * 2;
        double areaHeight = data.getDouble("area_height") * 2;
        double x, y, z;

        for (int i = 0; i < attempts; i++) {

            x = entity.method_23317() + (random.method_43058() - 0.5) * areaWidth;
            y = class_3532.method_15350(entity.method_23318() + (random.method_43048(Math.max((int) areaHeight, 1)) - (areaHeight / 2)), serverWorld.method_31607(), serverWorld.method_31607() + (serverWorld.method_32819() - 1));
            z = entity.method_23321() + (random.method_43058() - 0.5) * areaWidth;

            if (attemptToTeleport(entity, serverWorld, x, y, z, landingOffset.method_10216(), landingOffset.method_10214(), landingOffset.method_10215(), areaHeight, loadedChunksOnly, heightmap, landingBlockCondition, landingCondition)) {

                data.<Consumer<class_1297>>ifPresent("success_action", successAction -> successAction.accept(entity));
                entity.method_38785();

                succeeded = true;
                break;

            }

        }

        if (!succeeded) {
            data.<Consumer<class_1297>>ifPresent("fail_action", failAction -> failAction.accept(entity));
        }

    }

    private static boolean attemptToTeleport(class_1297 entity, class_3218 serverWorld, double destX, double destY, double destZ, double offsetX, double offsetY, double offsetZ, double areaHeight, boolean loadedChunksOnly, class_2902.class_2903 heightmap, Predicate<class_2694> landingBlockCondition, Predicate<class_1297> landingCondition) {

        class_2338.class_2339 blockPos = class_2338.method_49637(destX, destY, destZ).method_25503();
        boolean foundSurface = false;

        if (heightmap != null) {

            blockPos.method_10101(serverWorld.method_8598(heightmap, blockPos).method_10074());

            if (landingBlockCondition.test(new class_2694(serverWorld, blockPos, true))) {
                blockPos.method_10101(blockPos.method_10084());
                foundSurface = true;
            }

        } else {

            for (double decrements = 0; decrements < areaHeight / 2; ++decrements) {

                blockPos.method_10101(blockPos.method_10074());

                if (landingBlockCondition.test(new class_2694(serverWorld, blockPos, true))) {

                    blockPos.method_10101(blockPos.method_10084());
                    foundSurface = true;

                    break;

                }

            }

        }

        destX = offsetX == 0 ? destX : class_3532.method_15357(destX) + offsetX;
        destY = blockPos.method_10264() + offsetY;
        destZ = offsetZ == 0 ? destZ : class_3532.method_15357(destZ) + offsetZ;

        blockPos.method_10102(destX, destY, destZ);

        if (!foundSurface) {
            return false;
        }

        double prevX = entity.method_23317();
        double prevY = entity.method_23318();
        double prevZ = entity.method_23321();

        class_1923 chunkPos = new class_1923(blockPos);
        if (!serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {

            if (loadedChunksOnly) {
                return false;
            }

            serverWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 0, entity.method_5628());
            serverWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180);

        }

        entity.method_5859(destX, destY, destZ);

        if (!landingCondition.test(entity)) {
            entity.method_5859(prevX, prevY, prevZ);
            return false;
        }

        if (entity instanceof class_1314 pathAwareEntity) {
            pathAwareEntity.method_5942().method_6340();
        }

        return true;

    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory<>(
                Sync.identifier("random_teleport"),
                new SerializableData()
                        .add("area_width", SerializableDataTypes.DOUBLE, 8.0)
                        .add("area_height", SerializableDataTypes.DOUBLE, 8.0)
                        .add("heightmap", SerializableDataType.enumValue(class_2902.class_2903.class), null)
                        .addFunctionedDefault("attempts", SerializableDataTypes.INT, data -> (int) ((data.getDouble("area_width") * 2) + (data.getDouble("area_height") * 2)))
                        .add("landing_block_condition", ApoliDataTypes.BLOCK_CONDITION, null)
                        .add("landing_condition", ApoliDataTypes.ENTITY_CONDITION, null)
                        .add("landing_offset", SerializableDataTypes.VECTOR, class_243.field_1353)
                        .add("loaded_chunks_only", SerializableDataTypes.BOOLEAN, true)
                        .add("success_action", ApoliDataTypes.ENTITY_ACTION, null)
                        .add("fail_action", ApoliDataTypes.ENTITY_ACTION, null),
                RandomTeleportAction::action
        );
    }

}