package dev.overgrown.sync.factory.condition.entity;

import dev.overgrown.sync.Sync;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3545;

public class EntityInRadiusCondition {

    public static ConditionFactory<class_1297> getFactory() {
        return new ConditionFactory<>(
                Sync.identifier("entity_in_radius"),
                new SerializableData()
                        .add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null)
                        .add("shape", SerializableDataType.enumValue(Shape.class), Shape.CUBE)
                        .add("radius", SerializableDataTypes.FLOAT)
                        .add("comparison", ApoliDataTypes.COMPARISON, Comparison.GREATER_THAN_OR_EQUAL)
                        .add("compare_to", SerializableDataTypes.INT, 1),
                EntityInRadiusCondition::condition
        );
    }

    private static boolean condition(SerializableData.Instance data, class_1297 actor) {
        // Get parameters from data
        Predicate<class_3545<class_1297, class_1297>> bientityCondition = data.get("bientity_condition");
        Shape shape = data.get("shape");
        float radius = data.getFloat("radius");
        Comparison comparison = data.get("comparison");
        int compareTo = data.getInt("compare_to");

        // Calculate center position at actor's feet
        class_243 center = new class_243(actor.method_23317(), actor.method_5829().field_1322, actor.method_23321());

        // Create bounding box that covers the entire area
        double diameter = radius * 2;
        class_238 box = class_238.method_30048(center, diameter, diameter, diameter);

        // Get entities in the bounding box
        List<class_1297> entities = actor.method_37908().method_8335(actor, box);

        int count = 0;
        for (class_1297 target : entities) {
            // Calculate target's foot position
            class_243 targetFeet = new class_243(target.method_23317(), target.method_5829().field_1322, target.method_23321());

            // Calculate differences
            double dx = Math.abs(center.field_1352 - targetFeet.field_1352);
            double dy = Math.abs(center.field_1351 - targetFeet.field_1351);
            double dz = Math.abs(center.field_1350 - targetFeet.field_1350);

            // Calculate distance based on shape
            double distance = Shape.getDistance(shape, dx, dy, dz);

            // Check if within radius and satisfies bi-entity condition
            if (distance <= radius &&
                    (bientityCondition == null || bientityCondition.test(new class_3545<>(actor, target)))) {
                count++;
            }
        }

        // Compare count using the specified comparison
        return comparison.compare(count, compareTo);
    }
}