package dev.overgrown.sync.factory.condition.entity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.factory.power.type.EntitySetPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import net.minecraft.class_1297;
import net.minecraft.class_3545;

public class InEntitySetCondition {

    public static boolean condition(SerializableData.Instance data, class_3545<class_1297, class_1297> actorAndTarget) {

        PowerHolderComponent component = PowerHolderComponent.KEY.maybeGet(actorAndTarget.method_15442()).orElse(null);
        PowerType<?> powerType = data.get("set");

        if (component == null || powerType == null || !(component.getPower(powerType) instanceof EntitySetPower entitySetPower)) {
            return false;
        }

        return entitySetPower.contains(actorAndTarget.method_15441());

    }

    public static ConditionFactory<class_3545<class_1297, class_1297>> getFactory() {
        return new ConditionFactory<>(
                Sync.identifier("in_entity_set"),
                new SerializableData()
                        .add("set", ApoliDataTypes.POWER_TYPE),
                InEntitySetCondition::condition
        );
    }
}