package dev.overgrown.sync.factory.condition.entity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.utils.KeyPressManager;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public class KeyPressedCondition {

    public static boolean condition(SerializableData.Instance data, class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        String key = data.getString("key");
        boolean continuous = data.getBoolean("continuous");
        return KeyPressManager.getKeyState(entity.method_5667(), key, continuous);
    }

    public static ConditionFactory<class_1297> getFactory() {
        return new ConditionFactory<>(
                Sync.identifier("key_pressed"),
                new SerializableData()
                        .add("key", SerializableDataTypes.STRING)
                        .add("continuous", SerializableDataTypes.BOOLEAN, true),
                KeyPressedCondition::condition
        );
    }
}