package dev.overgrown.sync.mixin;

import dev.overgrown.sync.factory.power.type.FlipModelPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;

@Mixin(class_757.class)
public abstract class GameRendererMixin {

    @Shadow public abstract class_4184 getCamera();

    @Inject(method = "renderWorld", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V", shift = At.Shift.AFTER))
    private void voile$flipView(float tickDelta, long limitTime, class_4587 matrices, CallbackInfo ci) {
        class_1297 entity = this.getCamera().method_19331();
        if (entity == null) return;

        String string = class_124.method_539(entity.method_5477().getString());
        // Don't flip the entity's view if they would be flipped the right way up due to their name
        if ("Dinnerbone".equals(string) || "Grumm".equals(string)) return;

        List<FlipModelPower> powers = PowerHolderComponent.getPowers(entity, FlipModelPower.class);

        if (powers.stream().anyMatch(FlipModelPower::shouldFlipView)) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees(180f));
        }
    }
}