package dev.overgrown.sync.mixin;

import dev.overgrown.sync.factory.power.type.PosePower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Comparator;
import net.minecraft.class_1657;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin {

	@Inject(
			method = "updatePose",
			at = @At("HEAD"),
			cancellable = true
	)
	private void forcePlayerPose(CallbackInfo ci) {
		class_1657 player = (class_1657) (Object) this;
		PowerHolderComponent.getPowers(player, PosePower.class).stream()
				.max(Comparator.comparing(PosePower::getPriority))
				.ifPresent(power -> {
					player.method_18380(power.getPose());
					ci.cancel();
				});
	}
}