package dev.overgrown.sync.utils;

import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.PowerFactorySupplier;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2694;
import net.minecraft.class_3545;
import org.apache.commons.lang3.tuple.Triple;

public class ApoliRegistryHelper {

    public static void registerEntityCondition(ConditionFactory<class_1297> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.ENTITY_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
    }

    public static void registerEntityAction(ActionFactory<class_1297> actionFactory) {
        class_2378.method_10230(ApoliRegistries.ENTITY_ACTION, actionFactory.getSerializerId(), actionFactory);
    }

    public static void registerBientityAction(ActionFactory<class_3545<class_1297, class_1297>> actionFactory) {
        class_2378.method_10230(ApoliRegistries.BIENTITY_ACTION, actionFactory.getSerializerId(), actionFactory);
    }

    public static void registerBientityCondition(ConditionFactory<class_3545<class_1297, class_1297>> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.BIENTITY_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
    }

    public static void registerItemCondition(ConditionFactory<class_1799> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.ITEM_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
    }

    public static void registerItemAction(ActionFactory<class_3545<class_1937, class_1799>> actionFactory) {
        class_2378.method_10230(ApoliRegistries.ITEM_ACTION, actionFactory.getSerializerId(), actionFactory);
    }

    public static void registerBlockCondition(ConditionFactory<class_2694> conditionFactory) {
        class_2378.method_10230(ApoliRegistries.BLOCK_CONDITION, conditionFactory.getSerializerId(), conditionFactory);
    }

    public static void registerBlockAction(ActionFactory<Triple<class_1937, class_2338, class_2350>> actionFactory) { // Renamed parameter for clarity
        class_2378.method_10230(ApoliRegistries.BLOCK_ACTION, actionFactory.getSerializerId(), actionFactory);
    }

    public static void registerPowerFactory(PowerFactory<?> serializer) {
        class_2378.method_10230(ApoliRegistries.POWER_FACTORY, serializer.getSerializerId(), serializer);
    }

    public static void registerPowerFactorySupplier(PowerFactorySupplier<?> supplier) {
        registerPowerFactory(supplier.createFactory());
    }
}