/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.sync.factory.action.entity;

import dev.overgrown.sync.Sync;
import dev.overgrown.sync.factory.power.type.EntitySetPower;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_3545;

public class ActionOnEntitySetAction {
    public static void action(SerializableData.Instance data, class_1297 entity) {
        Power power;
        PowerHolderComponent component = PowerHolderComponent.KEY.maybeGet((Object)entity).orElse(null);
        PowerType powerType = (PowerType)data.get("set");
        if (component == null || powerType == null || !((power = component.getPower(powerType)) instanceof EntitySetPower)) {
            return;
        }
        EntitySetPower entitySetPower = (EntitySetPower)power;
        Consumer biEntityAction = (Consumer)data.get("bientity_action");
        Predicate biEntityCondition = (Predicate)data.get("bientity_condition");
        LinkedList<UUID> uuids = new LinkedList<UUID>(entitySetPower.getIterationSet());
        if (data.getBoolean("reverse")) {
            Collections.reverse(uuids);
        }
        int limit = (Integer)data.get("limit");
        int processedUuids = 0;
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        for (UUID uuid : uuids) {
            class_1297 entityFromSet = entitySetPower.getEntity(uuid);
            class_3545 entityPair = new class_3545((Object)entity, (Object)entityFromSet);
            if (biEntityCondition == null || biEntityCondition.test(entityPair)) {
                biEntityAction.accept(entityPair);
                ++processedUuids;
            }
            if (processedUuids < limit) continue;
            break;
        }
    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory(Sync.identifier("action_on_entity_set"), new SerializableData().add("set", ApoliDataTypes.POWER_TYPE).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("limit", SerializableDataTypes.INT, (Object)0).add("reverse", SerializableDataTypes.BOOLEAN, (Object)false), ActionOnEntitySetAction::action);
    }
}

