/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.sync.factory.action.entity;

import dev.overgrown.sync.Sync;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2694;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class RandomTeleportAction {
    public static void action(SerializableData.Instance data, class_1297 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        Predicate landingBlockCondition = data.isPresent("landing_block_condition") ? (Predicate)data.get("landing_block_condition") : cachedBlockPosition -> cachedBlockPosition.method_11681().method_26212((class_1922)cachedBlockPosition.method_11679(), cachedBlockPosition.method_11683());
        Predicate landingCondition = data.isPresent("landing_condition") ? (Predicate)data.get("landing_condition") : _entity -> serverWorld.method_17892(_entity) && !serverWorld.method_22345(_entity.method_5829());
        class_2902.class_2903 heightmap = (class_2902.class_2903)data.get("heightmap");
        class_5819 random = class_5819.method_43047();
        class_243 landingOffset = (class_243)data.get("landing_offset");
        boolean loadedChunksOnly = data.getBoolean("loaded_chunks_only");
        boolean succeeded = false;
        int attempts = data.getInt("attempts");
        double areaWidth = data.getDouble("area_width") * 2.0;
        double areaHeight = data.getDouble("area_height") * 2.0;
        for (int i = 0; i < attempts; ++i) {
            double z;
            double y;
            double x = entity.method_23317() + (random.method_43058() - 0.5) * areaWidth;
            if (!RandomTeleportAction.attemptToTeleport(entity, serverWorld, x, y = class_3532.method_15350((double)(entity.method_23318() + ((double)random.method_43048(Math.max((int)areaHeight, 1)) - areaHeight / 2.0)), (double)serverWorld.method_31607(), (double)(serverWorld.method_31607() + (serverWorld.method_32819() - 1))), z = entity.method_23321() + (random.method_43058() - 0.5) * areaWidth, landingOffset.method_10216(), landingOffset.method_10214(), landingOffset.method_10215(), areaHeight, loadedChunksOnly, heightmap, landingBlockCondition, landingCondition)) continue;
            data.ifPresent("success_action", successAction -> successAction.accept(entity));
            entity.method_38785();
            succeeded = true;
            break;
        }
        if (!succeeded) {
            data.ifPresent("fail_action", failAction -> failAction.accept(entity));
        }
    }

    private static boolean attemptToTeleport(class_1297 entity, class_3218 serverWorld, double destX, double destY, double destZ, double offsetX, double offsetY, double offsetZ, double areaHeight, boolean loadedChunksOnly, class_2902.class_2903 heightmap, Predicate<class_2694> landingBlockCondition, Predicate<class_1297> landingCondition) {
        boolean foundSurface;
        class_2338.class_2339 blockPos;
        block7: {
            block6: {
                blockPos = class_2338.method_49637((double)destX, (double)destY, (double)destZ).method_25503();
                foundSurface = false;
                if (heightmap == null) break block6;
                blockPos.method_10101((class_2382)serverWorld.method_8598(heightmap, (class_2338)blockPos).method_10074());
                if (!landingBlockCondition.test(new class_2694((class_4538)serverWorld, (class_2338)blockPos, true))) break block7;
                blockPos.method_10101((class_2382)blockPos.method_10084());
                foundSurface = true;
                break block7;
            }
            for (double decrements = 0.0; decrements < areaHeight / 2.0; decrements += 1.0) {
                blockPos.method_10101((class_2382)blockPos.method_10074());
                if (!landingBlockCondition.test(new class_2694((class_4538)serverWorld, (class_2338)blockPos, true))) continue;
                blockPos.method_10101((class_2382)blockPos.method_10084());
                foundSurface = true;
                break;
            }
        }
        destX = offsetX == 0.0 ? destX : (double)class_3532.method_15357((double)destX) + offsetX;
        destY = (double)blockPos.method_10264() + offsetY;
        destZ = offsetZ == 0.0 ? destZ : (double)class_3532.method_15357((double)destZ) + offsetZ;
        blockPos.method_10102(destX, destY, destZ);
        if (!foundSurface) {
            return false;
        }
        double prevX = entity.method_23317();
        double prevY = entity.method_23318();
        double prevZ = entity.method_23321();
        class_1923 chunkPos = new class_1923((class_2338)blockPos);
        if (!serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
            if (loadedChunksOnly) {
                return false;
            }
            serverWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 0, (Object)entity.method_5628());
            serverWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180);
        }
        entity.method_5859(destX, destY, destZ);
        if (!landingCondition.test(entity)) {
            entity.method_5859(prevX, prevY, prevZ);
            return false;
        }
        if (entity instanceof class_1314) {
            class_1314 pathAwareEntity = (class_1314)entity;
            pathAwareEntity.method_5942().method_6340();
        }
        return true;
    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory(Sync.identifier("random_teleport"), new SerializableData().add("area_width", SerializableDataTypes.DOUBLE, (Object)8.0).add("area_height", SerializableDataTypes.DOUBLE, (Object)8.0).add("heightmap", SerializableDataType.enumValue(class_2902.class_2903.class), null).addFunctionedDefault("attempts", SerializableDataTypes.INT, data -> (int)(data.getDouble("area_width") * 2.0 + data.getDouble("area_height") * 2.0)).add("landing_block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("landing_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("landing_offset", SerializableDataTypes.VECTOR, (Object)class_243.field_1353).add("loaded_chunks_only", SerializableDataTypes.BOOLEAN, (Object)true).add("success_action", ApoliDataTypes.ENTITY_ACTION, null).add("fail_action", ApoliDataTypes.ENTITY_ACTION, null), RandomTeleportAction::action);
    }
}

