/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.sync.factory.power.type;

import dev.overgrown.sync.Sync;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EntitySetPower
extends Power {
    private final Consumer<class_3545<class_1297, class_1297>> actionOnAdd;
    private final Consumer<class_3545<class_1297, class_1297>> actionOnRemove;
    private final int tickRate;
    private final Set<UUID> entityUuids = new HashSet<UUID>();
    private final Map<UUID, class_1297> entities = new HashMap<UUID, class_1297>();
    private final Set<UUID> tempUuids = new HashSet<UUID>();
    private final Map<UUID, Long> tempEntities = new ConcurrentHashMap<UUID, Long>();
    private Integer startTicks = null;
    private boolean wasActive = false;
    private boolean removedTemps = false;

    public EntitySetPower(PowerType<?> type, class_1309 entity, Consumer<class_3545<class_1297, class_1297>> actionOnAdd, Consumer<class_3545<class_1297, class_1297>> actionOnRemove, int tickRate) {
        super(type, entity);
        if (tickRate <= 0) {
            throw new IllegalArgumentException("Tick rate must be a positive integer");
        }
        this.actionOnAdd = actionOnAdd;
        this.actionOnRemove = actionOnRemove;
        this.tickRate = tickRate;
        this.setTicking(true);
    }

    public void onAdded() {
        this.removedTemps = this.entityUuids.removeIf(this.tempUuids::contains);
        this.tempUuids.clear();
    }

    public void tick() {
        if (this.removedTemps) {
            this.removedTemps = false;
            PowerHolderComponent.syncPower((class_1297)this.entity, (PowerType)this.type);
            return;
        }
        if (!this.tempEntities.isEmpty() && this.isActive()) {
            if (this.startTicks == null) {
                this.startTicks = this.entity.field_6012 % this.tickRate;
                return;
            }
            if (this.entity.field_6012 % this.tickRate == this.startTicks) {
                this.tickTempEntities();
            }
            this.wasActive = true;
        } else if (this.wasActive) {
            this.startTicks = null;
            this.wasActive = false;
        }
    }

    protected void tickTempEntities() {
        Iterator<Map.Entry<UUID, Long>> entryIterator = this.tempEntities.entrySet().iterator();
        long time = this.entity.method_37908().method_8510();
        while (entryIterator.hasNext()) {
            Map.Entry<UUID, Long> entry = entryIterator.next();
            if (time < entry.getValue()) continue;
            UUID uuid = entry.getKey();
            class_1297 tempEntity = this.getEntity(uuid);
            entryIterator.remove();
            if (!(this.entityUuids.remove(uuid) | this.entities.remove(uuid) != null | this.tempUuids.remove(uuid))) continue;
            if (this.actionOnRemove != null) {
                this.actionOnRemove.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)tempEntity));
            }
            this.removedTemps = true;
        }
    }

    public boolean validateEntities() {
        MinecraftServer server = this.entity.method_5682();
        if (server == null) {
            return false;
        }
        Iterator<UUID> uuidIterator = this.entityUuids.iterator();
        boolean valid = true;
        while (uuidIterator.hasNext()) {
            UUID uuid = uuidIterator.next();
            if (EntitySetPower.getEntityFromAllWorlds(server, uuid) != null) continue;
            uuidIterator.remove();
            this.entities.remove(uuid);
            this.tempUuids.remove(uuid);
            this.tempEntities.remove(uuid);
            valid = false;
        }
        return valid;
    }

    @Nullable
    private static class_1297 getEntityFromAllWorlds(MinecraftServer server, UUID uuid) {
        for (class_3218 world : server.method_3738()) {
            class_1297 entity = world.method_14190(uuid);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public boolean add(class_1297 entity) {
        return this.add(entity, null);
    }

    public boolean add(class_1297 entity, @Nullable Integer time) {
        if (entity == null || entity.method_31481() || entity.method_37908().field_9236) {
            return false;
        }
        UUID uuid = entity.method_5667();
        boolean addedToSet = false;
        if (time != null) {
            addedToSet |= this.tempUuids.add(uuid);
            this.tempEntities.compute(uuid, (prevUuid, prevTime) -> entity.method_37908().method_8510() + (long)time.intValue());
        }
        if (!this.entityUuids.contains(uuid)) {
            addedToSet |= this.entityUuids.add(uuid);
            this.entities.put(uuid, entity);
            if (this.actionOnAdd != null) {
                this.actionOnAdd.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)entity));
            }
        }
        return addedToSet;
    }

    public boolean remove(@Nullable class_1297 entity) {
        return this.remove(entity, true);
    }

    public boolean remove(@Nullable class_1297 entity, boolean executeRemoveAction) {
        if (entity == null || entity.method_37908().field_9236) {
            return false;
        }
        UUID uuid = entity.method_5667();
        boolean result = this.entityUuids.remove(uuid) | this.entities.remove(uuid) != null | this.tempUuids.remove(uuid) | this.tempEntities.remove(uuid) != null;
        if (executeRemoveAction && result && this.actionOnRemove != null) {
            this.actionOnRemove.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)entity));
        }
        return result;
    }

    public boolean contains(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return this.entities.containsValue(entity) || this.entityUuids.contains(entity.method_5667());
    }

    public int size() {
        return this.entityUuids.size();
    }

    public void clear() {
        if (this.actionOnRemove != null) {
            for (UUID entityUuid : this.entityUuids) {
                this.actionOnRemove.accept((class_3545<class_1297, class_1297>)new class_3545((Object)this.entity, (Object)this.getEntity(entityUuid)));
            }
        }
        boolean wasNotEmpty = !this.entityUuids.isEmpty() || !this.tempUuids.isEmpty();
        this.tempUuids.clear();
        this.tempEntities.clear();
        this.entityUuids.clear();
        this.entities.clear();
        if (wasNotEmpty) {
            PowerHolderComponent.syncPower((class_1297)this.entity, (PowerType)this.type);
        }
    }

    public Set<UUID> getIterationSet() {
        return new HashSet<UUID>(this.entityUuids);
    }

    @Nullable
    public class_1297 getEntity(UUID uuid) {
        if (!this.entityUuids.contains(uuid)) {
            return null;
        }
        class_1297 entity = this.entities.get(uuid);
        if (entity != null && !entity.method_31481()) {
            return entity;
        }
        MinecraftServer server = this.entity.method_5682();
        if (server != null && (entity = EntitySetPower.getEntityFromAllWorlds(server, uuid)) != null) {
            this.entities.put(uuid, entity);
            return entity;
        }
        return null;
    }

    public class_2520 toTag() {
        class_2487 rootNbt = new class_2487();
        class_2499 entityUuidsNbt = new class_2499();
        class_2499 tempUuidsNbt = new class_2499();
        for (UUID entityUuid : this.entityUuids) {
            class_2495 entityUuidNbt = class_2512.method_25929((UUID)entityUuid);
            entityUuidsNbt.add((Object)entityUuidNbt);
        }
        for (UUID tempUuid : this.tempUuids) {
            class_2495 tempUuidNbt = class_2512.method_25929((UUID)tempUuid);
            tempUuidsNbt.add((Object)tempUuidNbt);
        }
        rootNbt.method_10566("Entities", (class_2520)entityUuidsNbt);
        rootNbt.method_10566("TempEntities", (class_2520)tempUuidsNbt);
        rootNbt.method_10556("RemovedTemps", this.removedTemps);
        return rootNbt;
    }

    public void fromTag(class_2520 tag) {
        if (!(tag instanceof class_2487)) {
            return;
        }
        class_2487 rootNbt = (class_2487)tag;
        this.tempUuids.clear();
        this.tempEntities.clear();
        this.entityUuids.clear();
        this.entities.clear();
        class_2499 tempUuidsNbt = rootNbt.method_10554("TempEntities", 11);
        for (class_2520 tempUuidNbt : tempUuidsNbt) {
            UUID tempUuid = class_2512.method_25930((class_2520)tempUuidNbt);
            this.tempUuids.add(tempUuid);
        }
        class_2499 entityUuidsNbt = rootNbt.method_10554("Entities", 11);
        for (class_2520 entityUuidNbt : entityUuidsNbt) {
            UUID entityUuid = class_2512.method_25930((class_2520)entityUuidNbt);
            this.entityUuids.add(entityUuid);
        }
        this.removedTemps = rootNbt.method_10577("RemovedTemps");
    }

    public static void integrateLoadCallback(class_1297 loadedEntity, class_3218 world) {
        PowerHolderComponent.KEY.maybeGet((Object)loadedEntity).ifPresent(component -> component.getPowers(EntitySetPower.class, true).stream().filter(Predicate.not(EntitySetPower::validateEntities)).map(Power::getType).forEach(powerType -> PowerHolderComponent.syncPower((class_1297)loadedEntity, (PowerType)powerType)));
    }

    public static void integrateUnloadCallback(class_1297 unloadedEntity, class_3218 world) {
        class_1297.class_5529 removalReason = unloadedEntity.method_35049();
        if (removalReason == null || !removalReason.method_31486() || unloadedEntity instanceof class_1657) {
            return;
        }
        for (class_3218 otherWorld : world.method_8503().method_3738()) {
            for (class_1297 entity : otherWorld.method_27909()) {
                PowerHolderComponent.KEY.maybeGet((Object)entity).ifPresent(component -> component.getPowers(EntitySetPower.class, true).stream().filter(p -> p.remove(unloadedEntity, false)).map(Power::getType).forEach(powerType -> PowerHolderComponent.syncPower((class_1297)entity, (PowerType)powerType)));
            }
        }
    }

    public static PowerFactory<EntitySetPower> getFactory() {
        return new PowerFactory(Sync.identifier("entity_set"), new SerializableData().add("action_on_add", ApoliDataTypes.BIENTITY_ACTION, null).add("action_on_remove", ApoliDataTypes.BIENTITY_ACTION, null).add("tick_rate", SerializableDataTypes.INT, (Object)1), data -> (powerType, livingEntity) -> {
            int tickRate = data.getInt("tick_rate");
            return new EntitySetPower((PowerType<?>)powerType, (class_1309)livingEntity, (Consumer)data.get("action_on_add"), (Consumer)data.get("action_on_remove"), tickRate);
        }).allowCondition();
    }
}

