/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.sync.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;

public class KeyPressManager {
    private static final Map<UUID, Map<String, KeyState>> PLAYER_KEY_STATES = new ConcurrentHashMap<UUID, Map<String, KeyState>>();
    private static final Map<UUID, Map<String, Boolean>> PREVIOUS_KEY_STATES = new ConcurrentHashMap<UUID, Map<String, Boolean>>();

    public static void updateKeyState(UUID playerUuid, String key, boolean pressed) {
        PLAYER_KEY_STATES.computeIfAbsent(playerUuid, k -> new HashMap()).compute(key, (k, state) -> {
            if (state == null) {
                return new KeyState(pressed, class_156.method_658());
            }
            state.current = pressed;
            state.lastUpdateTime = class_156.method_658();
            return state;
        });
    }

    public static boolean getKeyState(UUID playerUuid, String key, boolean continuous) {
        Map<String, KeyState> playerKeys = PLAYER_KEY_STATES.get(playerUuid);
        if (playerKeys == null) {
            return false;
        }
        KeyState state = playerKeys.get(key);
        if (state == null) {
            return false;
        }
        if (continuous) {
            return state.current;
        }
        Map previousStates = PREVIOUS_KEY_STATES.computeIfAbsent(playerUuid, k -> new HashMap());
        boolean wasPressed = previousStates.getOrDefault(key, false);
        boolean isPressed = state.current;
        previousStates.put(key, isPressed);
        return isPressed && !wasPressed;
    }

    public static void removePlayer(UUID playerUuid) {
        PLAYER_KEY_STATES.remove(playerUuid);
        PREVIOUS_KEY_STATES.remove(playerUuid);
    }

    public static void serverTick(MinecraftServer server) {
        server.method_3760().method_14571().forEach(player -> {
            UUID uuid = player.method_5667();
            Map previousStates = PREVIOUS_KEY_STATES.computeIfAbsent(uuid, k -> new HashMap());
            Map<String, KeyState> currentStates = PLAYER_KEY_STATES.get(uuid);
            if (currentStates != null) {
                currentStates.forEach((key, state) -> previousStates.put(key, state.current));
            }
        });
    }

    private static class KeyState {
        boolean current;
        long lastUpdateTime;

        KeyState(boolean current, long lastUpdateTime) {
            this.current = current;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

