/*
 * Decompiled with CFR 0.152.
 */
package com.pokeskies.randomcollections.config;

import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.pokeskies.randomcollections.RandomCollections;
import com.pokeskies.randomcollections.config.MainConfig;
import com.pokeskies.randomcollections.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J;\u0010\u000f\u001a\u00028\u0000\"\b\b\u0000\u0010\b*\u00020\u00012\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J#\u0010\u0012\u001a\u00020\r\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/pokeskies/randomcollections/config/ConfigManager;", "", "<init>", "()V", "", "load", "copyDefaults", "loadCollections", "T", "", "filename", "default", "path", "", "create", "loadFile", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/Object;", "object", "saveFile", "(Ljava/lang/String;Ljava/lang/Object;)Z", "Ljava/lang/ClassLoader;", "classLoader", "fileName", "attemptDefaultFileCopy", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "directoryName", "attemptDefaultDirectoryCopy", "assetPackage", "Ljava/lang/String;", "Lcom/pokeskies/randomcollections/config/MainConfig;", "CONFIG", "Lcom/pokeskies/randomcollections/config/MainConfig;", "getCONFIG", "()Lcom/pokeskies/randomcollections/config/MainConfig;", "setCONFIG", "(Lcom/pokeskies/randomcollections/config/MainConfig;)V", "RandomCollections"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\ncom/pokeskies/randomcollections/config/ConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1557#2:160\n1628#2,3:161\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\ncom/pokeskies/randomcollections/config/ConfigManager\n*L\n45#1:160\n45#1:161,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    private static String assetPackage = "assets/randomcollections";
    public static MainConfig CONFIG;

    private ConfigManager() {
    }

    @NotNull
    public final MainConfig getCONFIG() {
        MainConfig mainConfig = CONFIG;
        if (mainConfig != null) {
            return mainConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"CONFIG");
        return null;
    }

    public final void setCONFIG(@NotNull MainConfig mainConfig) {
        Intrinsics.checkNotNullParameter((Object)mainConfig, (String)"<set-?>");
        CONFIG = mainConfig;
    }

    public final void load() {
        this.copyDefaults();
        this.setCONFIG((MainConfig)ConfigManager.loadFile$default(this, "config.json", new MainConfig(false, null, 3, null), null, false, 12, null));
        this.loadCollections();
    }

    private final void copyDefaults() {
        ClassLoader classLoader = RandomCollections.class.getClassLoader();
        RandomCollections.Companion.getINSTANCE().getConfigDir().mkdirs();
        Intrinsics.checkNotNull((Object)classLoader);
        this.attemptDefaultFileCopy(classLoader, "config.json");
        this.attemptDefaultDirectoryCopy(classLoader, "collections");
    }

    /*
     * WARNING - void declaration
     */
    private final void loadCollections() {
        File dir = FilesKt.resolve((File)RandomCollections.Companion.getINSTANCE().getConfigDir(), (String)"collections");
        if (dir.exists() && dir.isDirectory()) {
            List files = Files.walk(dir.toPath(), new FileVisitOption[0]).filter(arg_0 -> ConfigManager.loadCollections$lambda$1(ConfigManager::loadCollections$lambda$0, arg_0)).map(arg_0 -> ConfigManager.loadCollections$lambda$3(ConfigManager::loadCollections$lambda$2, arg_0)).collect(Collectors.toList());
            if (files != null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = files;
                int n = files.size();
                Logger logger = RandomCollections.Companion.getLOGGER();
                boolean $i$f$map = false;
                void var5_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                logger.info("Found " + n + " collection files: " + (List)collection);
                List enabledFiles = new ArrayList();
                for (File file : files) {
                    String fileName = file.getName();
                    if (this.getCONFIG().getCollections().containsKey(fileName)) {
                        Utils.INSTANCE.printError("Collection file " + fileName + " is already in the config, skipping...");
                        continue;
                    }
                    if (file.isFile()) {
                        Intrinsics.checkNotNull((Object)fileName);
                        if (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".json", (boolean)false, (int)2, null)) {
                            Object object;
                            Intrinsics.checkNotNullExpressionValue((Object)fileName.substring(0, StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".json", (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
                            try {
                                String id;
                                MainConfig.Collection collection2 = (MainConfig.Collection)RandomCollections.Companion.getINSTANCE().getGsonPretty().fromJson(JsonParser.parseReader((JsonReader)jsonReader), MainConfig.Collection.class);
                                this.getCONFIG().getCollections().put(id, collection2.getRewards());
                                object = enabledFiles.add(fileName);
                            }
                            catch (Exception ex) {
                                Utils.INSTANCE.printError("Error while trying to parse the collection file " + fileName + "!");
                                ex.printStackTrace();
                                object = Unit.INSTANCE;
                            }
                            continue;
                        }
                    }
                    Utils.INSTANCE.printError("File " + fileName + " is either not a file or is not a .json file!");
                }
                Utils.INSTANCE.printInfo("Successfully read and loaded the following enabled collection files: " + enabledFiles);
            }
        } else {
            Utils.INSTANCE.printError("The 'collections' directory either does not exist or is not a directory!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T> T loadFile(@NotNull String filename, @NotNull T t, @NotNull String path, boolean create) {
        Object value;
        block14: {
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter(t, (String)"default");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File dir = RandomCollections.Companion.getINSTANCE().getConfigDir();
            if (((CharSequence)path).length() > 0) {
                dir = FilesKt.resolve((File)dir, (String)path);
            }
            File file = new File(dir, filename);
            value = null;
            value = t;
            try {
                Files.createDirectories(RandomCollections.Companion.getINSTANCE().getConfigDir().toPath(), new FileAttribute[0]);
                if (file.exists()) {
                    Closeable closeable = new FileReader(file);
                    Throwable throwable = null;
                    try {
                        FileReader reader = (FileReader)closeable;
                        boolean bl = false;
                        JsonReader jsonReader = new JsonReader((Reader)reader);
                        value = RandomCollections.Companion.getINSTANCE().getGsonPretty().fromJson(jsonReader, (Type)t.getClass());
                        reader = Unit.INSTANCE;
                        break block14;
                    }
                    catch (Throwable reader) {
                        throwable = reader;
                        throw reader;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                if (!create) break block14;
                Files.createFile(file.toPath(), new FileAttribute[0]);
                Closeable closeable = new FileWriter(file);
                Throwable throwable = null;
                try {
                    FileWriter fileWriter = (FileWriter)closeable;
                    boolean bl = false;
                    fileWriter.write(RandomCollections.Companion.getINSTANCE().getGsonPretty().toJson(t));
                    fileWriter.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)value;
    }

    public static /* synthetic */ Object loadFile$default(ConfigManager configManager, String string, Object object, String string2, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return configManager.loadFile(string, object, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean saveFile(@NotNull String filename, T object) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        File dir = RandomCollections.Companion.getINSTANCE().getConfigDir();
        File file = new File(dir, filename);
        try {
            Closeable closeable = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = (FileWriter)closeable;
                boolean bl = false;
                fileWriter.write(RandomCollections.Companion.getINSTANCE().getGsonPretty().toJson(object));
                fileWriter.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private final void attemptDefaultFileCopy(ClassLoader classLoader, String fileName) {
        File file = FilesKt.resolve((File)RandomCollections.Companion.getINSTANCE().getConfigDir(), (String)fileName);
        if (!file.exists()) {
            file.mkdirs();
            try {
                InputStream inputStream = classLoader.getResourceAsStream(assetPackage + "/" + fileName);
                if (inputStream == null) {
                    throw new NullPointerException("File not found " + fileName);
                }
                InputStream stream = inputStream;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(stream, file.toPath(), copyOptionArray);
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default file '" + fileName + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void attemptDefaultDirectoryCopy(ClassLoader classLoader, String directoryName) {
        File directory = FilesKt.resolve((File)RandomCollections.Companion.getINSTANCE().getConfigDir(), (String)directoryName);
        if (!directory.exists()) {
            directory.mkdirs();
            try {
                URL uRL = classLoader.getResource(assetPackage + "/" + directoryName);
                if (uRL == null) {
                    throw new NullPointerException("Directory not found " + directoryName);
                }
                URL sourceUrl = uRL;
                Path sourcePath = Paths.get(sourceUrl.toURI());
                AutoCloseable autoCloseable = Files.walk(sourcePath, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    Stream stream = (Stream)autoCloseable;
                    boolean bl = false;
                    stream.forEach(arg_0 -> ConfigManager.attemptDefaultDirectoryCopy$lambda$10$lambda$9(arg_0 -> ConfigManager.attemptDefaultDirectoryCopy$lambda$10$lambda$8(directory, sourcePath, arg_0), arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Utils.INSTANCE.printError("Failed to copy the default directory '" + directoryName + "': " + e.getMessage());
            }
        }
    }

    private static final boolean loadCollections$lambda$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private static final boolean loadCollections$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final File loadCollections$lambda$2(Path it) {
        return it.toFile();
    }

    private static final File loadCollections$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    private static final Unit attemptDefaultDirectoryCopy$lambda$10$lambda$8(File $directory, Path $sourcePath, Path sourceFile) {
        Intrinsics.checkNotNullParameter((Object)$directory, (String)"$directory");
        File destinationFile = FilesKt.resolve((File)$directory, (String)((Object)$sourcePath.relativize(sourceFile)).toString());
        if (Files.isDirectory(sourceFile, new LinkOption[0])) {
            v0 = Boolean.valueOf(destinationFile.mkdirs());
        } else {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            v0 = Files.copy(sourceFile, destinationFile.toPath(), copyOptionArray);
        }
        return Unit.INSTANCE;
    }

    private static final void attemptDefaultDirectoryCopy$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

