/*
 * Decompiled with CFR 0.152.
 */
package xyz.ryhon.chatbinds;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ryhon.chatbinds.AddChatScreen;
import xyz.ryhon.chatbinds.BindMenuScreen;

public class ChatBinds
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chat-binds");
    static ArrayList<ChatBind> Binds = new ArrayList();
    static class_304.class_11900 UserCategory = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"chatbinds", (String)"user"));
    static Path configDir = FabricLoader.getInstance().getConfigDir().resolve("chatbinds");
    static Path configFileBinds = configDir.resolve("binds.json");

    public void onInitialize() {
        class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"chatbinds", (String)"chatbinds"));
        class_304 menuBind = new class_304("chatbinds.key.menu", class_3675.class_307.field_1668, -1, category);
        KeyBindingHelper.registerKeyBinding((class_304)menuBind);
        class_304 addChatBind = new class_304("chatbinds.key.add_chat", class_3675.class_307.field_1668, -1, category);
        KeyBindingHelper.registerKeyBinding((class_304)addChatBind);
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (menuBind.method_1436()) {
                client.method_1507((class_437)new BindMenuScreen(null));
            }
            if (addChatBind.method_1436()) {
                client.method_1507((class_437)new AddChatScreen("", null));
            }
            for (ChatBind b : Binds) {
                if (!b.bind.method_1436()) continue;
                ChatBinds.sendMessage(b.cmd);
            }
        });
        ChatBinds.loadConfig();
    }

    public static void sendMessage(String msg) {
        if (msg.startsWith("/")) {
            class_310.method_1551().field_1724.field_3944.method_45730(msg.substring(1));
        } else {
            class_310.method_1551().field_1724.field_3944.method_45729(msg);
        }
    }

    public static ChatBind registerCommand(String cmd, String title) {
        ChatBind b = new ChatBind();
        b.cmd = cmd;
        b.title = title;
        b.bind = new class_304(title, class_3675.class_307.field_1668, -1, UserCategory);
        class_310 mc = class_310.method_1551();
        if (mc.field_1690 != null) {
            ArrayList<class_304> keys = new ArrayList<class_304>();
            keys.addAll(Arrays.asList(mc.field_1690.field_1839));
            keys.add(b.bind);
            mc.field_1690.field_1839 = keys.toArray(new class_304[0]);
        } else {
            KeyBindingHelper.registerKeyBinding((class_304)b.bind);
        }
        Binds.add(b);
        return b;
    }

    public static void removeCommand(ChatBind bind) {
        Binds.remove(bind);
        class_310 mc = class_310.method_1551();
        ArrayList<class_304> keys = new ArrayList<class_304>();
        keys.addAll(Arrays.asList(mc.field_1690.field_1839));
        keys.remove(bind.bind);
        mc.field_1690.field_1839 = keys.toArray(new class_304[0]);
    }

    static void loadConfig() {
        class_310 mc = class_310.method_1551();
        if (Binds != null && mc.field_1690 != null) {
            ArrayList<class_304> keys = new ArrayList<class_304>();
            keys.addAll(Arrays.asList(mc.field_1690.field_1839));
            for (ChatBind b : Binds) {
                keys.remove(b.bind);
            }
            mc.field_1690.field_1839 = keys.toArray(new class_304[0]);
        }
        Binds = new ArrayList();
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            if (!Files.exists(configFileBinds, new LinkOption[0])) {
                return;
            }
            String str = Files.readString(configFileBinds);
            JsonArray ja = (JsonArray)JsonParser.parseString((String)str);
            for (JsonElement je : ja) {
                if (!(je instanceof JsonObject)) continue;
                JsonObject jo = (JsonObject)je;
                ChatBinds.registerCommand(jo.get("cmd").getAsString(), jo.get("title").getAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    static void saveConfig() {
        JsonArray ja = new JsonArray();
        for (ChatBind b : Binds) {
            JsonObject jo = new JsonObject();
            jo.add("cmd", (JsonElement)new JsonPrimitive(b.cmd));
            jo.add("title", (JsonElement)new JsonPrimitive(b.title));
            ja.add((JsonElement)jo);
        }
        String json = new Gson().toJson((JsonElement)ja);
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            Files.writeString(configFileBinds, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    static class ChatBind {
        public class_304 bind;
        public String cmd;
        public String title;

        ChatBind() {
        }
    }
}

