/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.atlases;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_330;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import svenhjol.charm.feature.atlases.AtlasContainer;
import svenhjol.charm.feature.atlases.AtlasImageButton;
import svenhjol.charm.feature.atlases.AtlasInventory;
import svenhjol.charm.feature.atlases.AtlasMapHelper;
import svenhjol.charm.feature.atlases.AtlasesClient;
import svenhjol.charm.feature.atlases.AtlasesNetwork;
import svenhjol.charm.feature.atlases.MoveMode;
import svenhjol.charmony.base.CharmonyContainerScreen;
import svenhjol.charmony.helper.KeyboardHelper;

public class AtlasScreen
extends CharmonyContainerScreen<AtlasContainer> {
    private static final class_1921 MAP_DECORATIONS = class_1921.method_23028((class_2960)new class_2960("textures/map/map_icons.png"));
    private static final int SIZE = 48;
    private static final int LEFT = 74;
    private static final int TOP = 16;
    private static final int BUTTON_SIZE = 9;
    private static final int BUTTON_DISTANCE = 3;
    private static final int CENTER = 19;
    private static final int MAX_MAPS = 8;
    private static final int NORMAL_SIZE = 128;
    private static final float BASE_SCALE = 0.375f;
    private static final int LIGHT = 240;
    private final WorldMap worldMap = new WorldMap();
    private final SingleMap singleMap = new SingleMap(null);
    private Map<ButtonDirection, AtlasImageButton> buttons;
    private MapGui mapGui;
    private int slot;
    private int lastSize;
    private class_330 mapItemRenderer;
    private final class_1657 player;
    private final class_1661 inventory;

    public AtlasScreen(AtlasContainer menu, class_1661 inv, class_2561 title) {
        super((class_1703)menu, inv, title, AtlasesClient.CONTAINER_BACKGROUND);
        this.field_2792 = 175;
        this.field_2779 = 168;
        this.inventory = inv;
        this.player = inv.field_7546;
    }

    protected void method_25426() {
        super.method_25426();
        AtlasInventory atlasInventory = ((AtlasContainer)this.field_2797).getInventory();
        this.slot = this.inventory.method_7395(atlasInventory.getAtlasItem());
        Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = atlasInventory.getCurrentDimensionMapInfos((class_1937)this.field_22787.field_1687);
        this.lastSize = mapInfos.size();
        this.mapGui = this.lastSize > 1 ? this.getWorldMap() : this.getSingleMap(this.lastSize == 0 ? null : mapInfos.values().iterator().next());
        this.buttons = new EnumMap<ButtonDirection, AtlasImageButton>(ButtonDirection.class);
        for (ButtonDirection direction : ButtonDirection.values()) {
            this.buttons.put(direction, this.createButton(direction));
        }
        this.mapItemRenderer = this.field_22787.field_1773.method_3194();
    }

    private AtlasImageButton createButton(ButtonDirection dir) {
        return new AtlasImageButton(() -> this.getX() + 74 + dir.left, () -> this.getY() + 16 + dir.top, dir.width, dir.height, dir.texStart, 0, dir.height, 2 * dir.height, AtlasesClient.INVENTORY_BUTTONS, it -> this.mapGui.buttonClick(dir));
    }

    private WorldMap getWorldMap() {
        this.worldMap.fixedMapDistance = false;
        return this.worldMap;
    }

    private SingleMap getSingleMap(AtlasInventory.MapInfo mapInfo) {
        this.singleMap.mapInfo = mapInfo;
        return this.singleMap;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.updateGui();
        this.updateButtonState();
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        pose.method_46416(74.0f, 16.0f, 0.0f);
        pose.method_22905(0.375f, 0.375f, 1.0f);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 background = bufferSource.getBuffer(AtlasesClient.MAP_BACKGROUND);
        AtlasMapHelper.drawBackgroundVertex(pose, 240, background);
        this.mapGui.render(guiGraphics, bufferSource, mouseX, mouseY);
        bufferSource.method_22993();
        pose.method_22909();
    }

    private void updateGui() {
        Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)this.field_2797).getInventory().getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
        int size = mapInfos.size();
        if (this.mapGui instanceof WorldMap) {
            if (mapInfos.size() <= 1) {
                this.changeGui(this.getSingleMap(mapInfos.isEmpty() ? null : mapInfos.values().iterator().next()));
            }
        } else if (this.mapGui instanceof SingleMap && size > this.lastSize) {
            mapInfos.values().stream().skip(size - 1).findAny().ifPresent(it -> this.changeGui(this.getSingleMap((AtlasInventory.MapInfo)it)));
        }
        this.lastSize = size;
    }

    private void updateButtonState() {
        this.buttons.forEach((direction, button) -> {
            button.field_22764 = this.mapGui.buttonVisible((ButtonDirection)((Object)direction));
            if (button.field_22764) {
                button.field_22763 = this.mapGui.buttonEnabled((ButtonDirection)((Object)direction));
                if (!this.field_33815.contains(button)) {
                    this.method_37063((class_364)button);
                }
            } else {
                this.removeButton((class_339)button);
            }
        });
    }

    private void removeButton(class_339 button) {
        this.field_33815.remove(button);
        this.field_22786.remove(button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mapGui.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        if (type == class_1713.field_7794) {
            AtlasesNetwork.TransferAtlas.send(this.slot, slot.field_7874, -1, MoveMode.FROM_INVENTORY);
        } else {
            super.method_2383(slot, slotId, mouseButton, type);
        }
    }

    private void changeGui(MapGui gui) {
        this.mapGui = gui;
    }

    private void renderDecorations(class_4587 pose, class_4597 buffer, class_22 mapData, float relativeScale, Predicate<class_20> filter) {
        int k = 0;
        for (class_20 mapdecoration : mapData.method_32373()) {
            if (!filter.test(mapdecoration)) continue;
            pose.method_22903();
            pose.method_22904((double)((float)mapdecoration.method_90() / 2.0f + 64.0f), (double)((float)mapdecoration.method_91() / 2.0f + 64.0f), 0.02);
            pose.method_22907(class_7833.field_40718.rotationDegrees((float)mapdecoration.method_89() * 22.5f));
            pose.method_22905(relativeScale * 4.0f, relativeScale * 4.0f, 3.0f);
            pose.method_22904(-0.125, 0.125, 0.0);
            byte b0 = mapdecoration.method_92();
            float f1 = (float)(b0 % 16) / 16.0f;
            float f2 = (float)(b0 / 16) / 16.0f;
            float f3 = (float)(b0 % 16 + 1) / 16.0f;
            float f4 = (float)(b0 / 16 + 1) / 16.0f;
            Matrix4f matrix4f = pose.method_23760().method_23761();
            class_4588 builder = buffer.getBuffer(MAP_DECORATIONS);
            float z = (float)k * 0.001f;
            builder.method_22918(matrix4f, -1.0f, 1.0f, z).method_1336(255, 255, 255, 255).method_22913(f1, f2).method_22916(240).method_1344();
            builder.method_22918(matrix4f, 1.0f, 1.0f, z).method_1336(255, 255, 255, 255).method_22913(f3, f2).method_22916(240).method_1344();
            builder.method_22918(matrix4f, 1.0f, -1.0f, z).method_1336(255, 255, 255, 255).method_22913(f3, f4).method_22916(240).method_1344();
            builder.method_22918(matrix4f, -1.0f, -1.0f, z).method_1336(255, 255, 255, 255).method_22913(f1, f4).method_22916(240).method_1344();
            pose.method_22909();
            ++k;
        }
    }

    private int getX() {
        return this.field_2776;
    }

    private int getY() {
        return this.field_2800;
    }

    private class WorldMap
    implements MapGui {
        private final Collector<AtlasInventory.Index, ?, Extremes> extremesCollector = Collector.of(() -> new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE}, (acc, index) -> {
            if (acc[0] > index.x) {
                acc[0] = index.x;
            }
            if (acc[1] < index.x) {
                acc[1] = index.x;
            }
            if (acc[2] > index.y) {
                acc[2] = index.y;
            }
            if (acc[3] < index.y) {
                acc[3] = index.y;
            }
        }, (acc1, acc2) -> {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                acc1[n] = acc1[n] + acc2[i];
            }
            return acc1;
        }, acc -> new Extremes(acc[0], acc[1], acc[2], acc[3]), new Collector.Characteristics[0]);
        private AtlasInventory.Index corner = null;
        private Extremes extremes = new Extremes(0, 0, 0, 0);
        private int maxMapDistance = 1;
        private int mapDistance = 1;
        private boolean fixedMapDistance = false;

        private WorldMap() {
        }

        private boolean updateExtremes() {
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
            if (mapInfos.isEmpty()) {
                return false;
            }
            this.extremes = mapInfos.keySet().stream().collect(this.extremesCollector);
            this.maxMapDistance = this.extremes.getMaxDistance();
            if (this.maxMapDistance > 8) {
                this.maxMapDistance = 8;
            }
            int n = this.mapDistance = this.fixedMapDistance ? Math.min(this.mapDistance, this.maxMapDistance) : this.maxMapDistance;
            if (this.mapDistance < this.maxMapDistance || this.mapDistance == 8) {
                if (this.corner == null) {
                    this.corner = inventory.getIndexOf(AtlasScreen.this.player).minus(this.mapDistance / 2).clamp(this.extremes.min, this.extremes.max.plus(1 - this.mapDistance));
                }
            } else {
                this.corner = null;
            }
            return true;
        }

        @Override
        public void render(class_332 guiGraphics, class_4597.class_4598 bufferSource, int mouseX, int mouseY) {
            class_310 mc = class_310.method_1551();
            class_638 level = mc.field_1687;
            if (level == null || !this.updateExtremes()) {
                return;
            }
            float mapSize = 128.0f / (float)this.mapDistance;
            float mapScale = 1.0f / (float)this.mapDistance;
            AtlasInventory.Index currentMin = this.corner != null ? this.corner : this.extremes.min;
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
            AtlasInventory.Index playerIndex = inventory.getIndexOf(AtlasScreen.this.player);
            for (Map.Entry<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfo : mapInfos.entrySet()) {
                int mapId;
                class_22 mapData;
                AtlasInventory.Index key = mapInfo.getKey();
                if (this.corner != null && (this.corner.x > key.x || key.x >= this.corner.x + this.mapDistance || this.corner.y > key.y || key.y >= this.corner.y + this.mapDistance) || (mapData = level.method_17891(class_1806.method_17440((int)(mapId = mapInfo.getValue().id)))) == null) continue;
                class_4587 pose = guiGraphics.method_51448();
                pose.method_22903();
                pose.method_22904((double)(mapSize * (float)(key.x - currentMin.x)), (double)(mapSize * (float)(key.y - currentMin.y)), 0.1);
                pose.method_22905(mapScale, mapScale, 1.0f);
                AtlasScreen.this.mapItemRenderer.method_1773(pose, (class_4597)bufferSource, mapId, mapData, false, 240);
                pose.method_22904(0.0, 0.0, 0.2);
                AtlasScreen.this.renderDecorations(pose, (class_4597)bufferSource, mapData, 1.5f * (float)this.mapDistance, it -> it.method_93() != class_20.class_21.field_86 && it.method_93() != class_20.class_21.field_87 && (it.method_93() != class_20.class_21.field_91 || key.equals(playerIndex)));
                pose.method_22909();
            }
            this.drawLines(guiGraphics);
        }

        private void drawLines(class_332 guiGraphics) {
            class_4587 pose = guiGraphics.method_51448();
            pose.method_22903();
            pose.method_22904(0.0, 0.0, 0.2);
            pose.method_22905(1.3333334f, 1.3333334f, 1.0f);
            for (int xLine = 1; xLine < this.mapDistance; ++xLine) {
                guiGraphics.method_25301(xLine * 2 * 48 / this.mapDistance, 0, 96, -1);
            }
            for (int yLine = 1; yLine < this.mapDistance; ++yLine) {
                guiGraphics.method_25292(0, 96, yLine * 2 * 48 / this.mapDistance, -1);
            }
            pose.method_22909();
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double normX = this.normalizeForMapArea(74 + AtlasScreen.this.getX(), mouseX);
            double normY = this.normalizeForMapArea(16 + AtlasScreen.this.getY(), mouseY);
            if (button == 0 && 0.0 <= normX && normX < 1.0 && 0.0 <= normY && normY < 1.0) {
                class_1799 heldItem = ((AtlasContainer)AtlasScreen.this.field_2797).method_34255();
                if (!heldItem.method_7960()) {
                    AtlasesNetwork.TransferAtlas.send(AtlasScreen.this.slot, -1, -1, MoveMode.FROM_HAND);
                } else if (this.updateExtremes()) {
                    AtlasInventory.Index currentMin = this.corner != null ? this.corner : this.extremes.min;
                    AtlasInventory.Index index = AtlasInventory.Index.of((int)(normX * (double)this.mapDistance), (int)(normY * (double)this.mapDistance)).plus(currentMin);
                    Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory().getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
                    AtlasInventory.MapInfo mapInfo = mapInfos.get(index);
                    if (mapInfo != null) {
                        if (KeyboardHelper.isHoldingShift()) {
                            AtlasesNetwork.TransferAtlas.send(AtlasScreen.this.slot, mapInfo.x, mapInfo.z, MoveMode.TO_INVENTORY);
                        } else {
                            AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfo));
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void buttonClick(ButtonDirection direction) {
            switch (direction.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.corner == null) break;
                    this.corner = this.corner.plus(direction.vector.multiply(this.mapDistance)).clamp(this.extremes.min, this.extremes.max.plus(1 - this.mapDistance));
                    break;
                }
                case 6: {
                    this.fixedMapDistance = true;
                    --this.mapDistance;
                    if (this.mapDistance != 1) break;
                    Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory().getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfos.get(this.corner != null ? this.corner : this.extremes.min)));
                    break;
                }
                case 5: {
                    this.fixedMapDistance = true;
                    ++this.mapDistance;
                }
            }
        }

        @Override
        public boolean buttonVisible(ButtonDirection direction) {
            return switch (direction.ordinal()) {
                case 0, 1, 2, 3 -> {
                    if (this.corner != null) {
                        yield true;
                    }
                    yield false;
                }
                case 5, 6 -> true;
                default -> false;
            };
        }

        @Override
        public boolean buttonEnabled(ButtonDirection direction) {
            return switch (direction.ordinal()) {
                case 0 -> {
                    if (this.corner != null && this.corner.x > this.extremes.min.x) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (this.corner != null && this.corner.y > this.extremes.min.y) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (this.corner != null && this.corner.x + this.mapDistance <= this.extremes.max.x) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (this.corner != null && this.corner.y + this.mapDistance <= this.extremes.max.y) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> {
                    if (this.mapDistance > 1) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (this.mapDistance < this.maxMapDistance) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        private double normalizeForMapArea(double base, double val) {
            return (val - base) / 48.0;
        }
    }

    private class SingleMap
    implements MapGui {
        private final Set<ButtonDirection> supportedDirections = EnumSet.of(ButtonDirection.LEFT, ButtonDirection.TOP, ButtonDirection.RIGHT, ButtonDirection.BOTTOM, ButtonDirection.BACK);
        private AtlasInventory.MapInfo mapInfo;

        public SingleMap(AtlasInventory.MapInfo mapInfo) {
            this.mapInfo = mapInfo;
        }

        @Override
        public void render(class_332 guiGraphics, class_4597.class_4598 bufferSource, int mouseX, int mouseY) {
            int mapId;
            class_22 mapData;
            class_310 mc = class_310.method_1551();
            class_638 level = mc.field_1687;
            if (level == null) {
                return;
            }
            if (this.mapInfo != null && (mapData = level.method_17891(class_1806.method_17440((int)(mapId = this.mapInfo.id)))) != null) {
                class_4587 pose = guiGraphics.method_51448();
                pose.method_22903();
                pose.method_46416(0.0f, 0.0f, 1.0f);
                AtlasScreen.this.mapItemRenderer.method_1773(pose, (class_4597)bufferSource, mapId, mapData, true, 240);
                AtlasScreen.this.renderDecorations(pose, (class_4597)bufferSource, mapData, 2.0f, it -> true);
                pose.method_22909();
            }
        }

        @Override
        public void buttonClick(ButtonDirection direction) {
            if (direction == ButtonDirection.BACK) {
                AtlasScreen.this.changeGui(AtlasScreen.this.getWorldMap());
            } else {
                AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory();
                Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
                AtlasInventory.MapInfo mapInfo1 = mapInfos.get(inventory.convertCoordsToIndex(this.mapInfo.x, this.mapInfo.z).plus(direction.vector));
                if (mapInfo1 != null) {
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(mapInfo1));
                }
            }
        }

        @Override
        public boolean buttonVisible(ButtonDirection direction) {
            return this.supportedDirections.contains((Object)direction);
        }

        @Override
        public boolean buttonEnabled(ButtonDirection direction) {
            AtlasInventory inventory = ((AtlasContainer)AtlasScreen.this.field_2797).getInventory();
            Map<AtlasInventory.Index, AtlasInventory.MapInfo> mapInfos = inventory.getCurrentDimensionMapInfos((class_1937)class_310.method_1551().field_1687);
            if (direction == ButtonDirection.BACK) {
                return this.mapInfo == null && !mapInfos.isEmpty() || mapInfos.size() > 1;
            }
            if (this.mapInfo != null) {
                return mapInfos.containsKey(inventory.convertCoordsToIndex(this.mapInfo.x, this.mapInfo.z).plus(direction.vector));
            }
            return false;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && (double)(AtlasScreen.this.getX() + 74) <= mouseX && mouseX < (double)(AtlasScreen.this.getX() + 74 + 48) && (double)(AtlasScreen.this.getY() + 16) <= mouseY && mouseY < (double)(AtlasScreen.this.getY() + 16 + 48)) {
                class_1799 heldItem = ((AtlasContainer)AtlasScreen.this.field_2797).method_34255();
                if (!heldItem.method_7960()) {
                    AtlasesNetwork.TransferAtlas.send(AtlasScreen.this.slot, -1, -1, MoveMode.FROM_HAND);
                } else if (this.mapInfo != null) {
                    if (KeyboardHelper.isHoldingShift()) {
                        AtlasesNetwork.TransferAtlas.send(AtlasScreen.this.slot, this.mapInfo.x, this.mapInfo.z, MoveMode.TO_INVENTORY);
                    } else {
                        AtlasesNetwork.TransferAtlas.send(AtlasScreen.this.slot, this.mapInfo.x, this.mapInfo.z, MoveMode.TO_HAND);
                    }
                    AtlasScreen.this.changeGui(AtlasScreen.this.getSingleMap(null));
                }
                return true;
            }
            return false;
        }
    }

    private static interface MapGui {
        public void render(class_332 var1, class_4597.class_4598 var2, int var3, int var4);

        default public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return false;
        }

        public void buttonClick(ButtonDirection var1);

        public boolean buttonVisible(ButtonDirection var1);

        public boolean buttonEnabled(ButtonDirection var1);
    }

    private static enum ButtonDirection {
        LEFT(-12, 19, 9, 9, 77, -1, 0),
        TOP(19, -12, 9, 9, 50, 0, -1),
        RIGHT(51, 19, 9, 9, 68, 1, 0),
        BOTTOM(19, 51, 9, 9, 59, 0, 1),
        BACK(82, -12, 16, 16, 86, 0, 0),
        OUT(79, 46, 8, 9, 102, 0, 0),
        IN(87, 46, 8, 9, 110, 0, 0);

        final int left;
        final int top;
        final int width;
        final int height;
        final int texStart;
        final AtlasInventory.Index vector;

        private ButtonDirection(int left, int top, int width, int height, int texStart, int x, int y) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.texStart = texStart;
            this.vector = AtlasInventory.Index.of(x, y);
        }
    }

    private static class Extremes {
        public final AtlasInventory.Index min;
        public final AtlasInventory.Index max;

        private Extremes(int minX, int maxX, int minY, int maxY) {
            this.min = AtlasInventory.Index.of(minX, minY);
            this.max = AtlasInventory.Index.of(maxX, maxY);
        }

        public int getMaxDistance() {
            return Math.max(this.max.x + 1 - this.min.x, this.max.y + 1 - this.min.y);
        }
    }
}

