/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.colored_glint_smithing_templates;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_60;
import net.minecraft.class_77;
import net.minecraft.class_79;
import svenhjol.charm.CharmTags;
import svenhjol.charm.feature.colored_glint_smithing_templates.ColoredGlintTemplateItem;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.LootTableModifyEvent;
import svenhjol.charmony.api.event.SmithingTableEvents;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.feature.colored_glints.ColoredGlints;
import svenhjol.charmony.iface.ICommonRegistry;

public class ColoredGlintSmithingTemplates
extends CommonFeature {
    public static final String ITEM_ID = "colored_glint_smithing_template";
    static List<class_2960> emptyDyes = new ArrayList<class_2960>();
    public static Supplier<class_1792> item;
    @Configurable(name="Loot table", description="Loot table in which a colored glint smithing template will be added.")
    public static String lootTable;
    @Configurable(name="Loot chance", description="Chance (out of 1.0) of a colored glint smithing template appearing in loot.")
    public static double lootChance;

    public String description() {
        return "Smithing template that changes the glint color of any enchanted item.";
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        emptyDyes.addAll(List.of(this.mod().id("item/empty_dye_01"), this.mod().id("item/empty_dye_02"), this.mod().id("item/empty_dye_03"), this.mod().id("item/empty_dye_04")));
        item = registry.item(ITEM_ID, ColoredGlintTemplateItem::new);
    }

    public void runWhenEnabled() {
        SmithingTableEvents.CAN_PLACE.handle(this::handleCanPlace);
        SmithingTableEvents.CALCULATE_OUTPUT.handle(this::handleCalculateOutput);
        SmithingTableEvents.CAN_TAKE.handle(this::handleCanTake);
        SmithingTableEvents.ON_TAKE.handle(this::handleOnTake);
        LootTableModifyEvent.INSTANCE.handle(this::handleLootTableModify);
    }

    private Optional<class_55.class_56> handleLootTableModify(class_60 manager, class_2960 id) {
        if (id.toString().equals(lootTable)) {
            class_55.class_56 builder = class_55.method_347();
            if (class_5819.method_43047().method_43058() < lootChance) {
                builder.method_352((class_5658)class_44.method_32448((float)1.0f));
            }
            builder.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)item.get())).method_437(1));
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    private class_1269 handleCanTake(SmithingTableEvents.SmithingTableInstance instance, class_1657 player) {
        class_1799 out;
        if (!instance.output.method_5442() && ColoredGlints.hasColoredGlint((class_1799)(out = instance.output.method_5438(0)))) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean handleCalculateOutput(SmithingTableEvents.SmithingTableInstance instance) {
        class_1263 input = instance.input;
        class_1799 slot0 = input.method_5438(0);
        class_1799 slot1 = input.method_5438(1);
        class_1799 slot2 = input.method_5438(2);
        if (slot0.method_31574(item.get())) {
            if (!slot1.method_7942() || !slot2.method_31573(CharmTags.COLORED_DYES)) {
                instance.output.method_5447(0, class_1799.field_8037);
                return true;
            }
            class_1767 dyeColor = ((class_1769)slot2.method_7909()).method_7802();
            class_1799 itemToChange = slot1.method_7972();
            ColoredGlints.applyColoredGlint((class_1799)itemToChange, (class_1767)dyeColor);
            instance.output.method_5447(0, itemToChange);
            return true;
        }
        return false;
    }

    private boolean handleCanPlace(class_1799 template, int slotNumber, class_1799 stack) {
        if (slotNumber == 0 && stack.method_31574(template.method_7909())) {
            return true;
        }
        if (slotNumber == 1 && stack.method_7942()) {
            return true;
        }
        return slotNumber == 2 && stack.method_31573(CharmTags.COLORED_DYES);
    }

    private boolean handleOnTake(SmithingTableEvents.SmithingTableInstance instance, class_1657 player, class_1799 stack) {
        if (ColoredGlints.hasColoredGlint((class_1799)stack)) {
            ColoredGlintSmithingTemplates.triggerAppliedColoredGlintTemplate(player);
        }
        return false;
    }

    public static void triggerAppliedColoredGlintTemplate(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "applied_colored_glint_template"), (class_1657)player);
    }

    static {
        lootTable = "minecraft:chests/stronghold_library";
        lootChance = 1.0;
    }
}

