/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.compass_overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.HudRenderEvent;
import svenhjol.charmony.client.ClientFeature;

public class CompassOverlay
extends ClientFeature {
    @Configurable(name="Facing", description="If true, shows the cardinal direction that the player is facing.", requireRestart=false)
    public static boolean showFacing = true;
    @Configurable(name="Co-ordinates", description="If true, shows the player's XYZ coordinates.", requireRestart=false)
    public static boolean showCoords = true;
    @Configurable(name="Biome", description="If true, shows the player's biome.", requireRestart=false)
    public static boolean showBiome = true;
    @Configurable(name="Only show X and Z", description="If true, only show the player's X and Z coordinates (not their height/depth).", requireRestart=false)
    public static boolean onlyXZ = false;
    @Configurable(name="Show when sneaking", description="If true, only show the compass overlay if the player is sneaking.", requireRestart=false)
    public static boolean onlyShowWhenSneaking = false;
    @Configurable(name="Always show", description="If true, the overlay will always be shown even if the player is not holding a compass.", requireRestart=false)
    public static boolean alwaysShow = false;
    @Configurable(name="Compact view", description="If true, the overlay will be shown in smaller text and in top left of the screen.", requireRestart=false)
    public static boolean compactView = false;

    public boolean canBeDisabled() {
        return true;
    }

    public String description() {
        return "Shows cardinal points and XYZ coordinates when holding a compass.";
    }

    public void runWhenEnabled() {
        HudRenderEvent.INSTANCE.handle(this::handleHudRender);
    }

    private void handleHudRender(class_332 guiGraphics, float tickDelta) {
        class_2960 biomeRes;
        float lineHeight;
        int facingOffsetX;
        int coordsOffsetX;
        float y;
        float x;
        class_310 minecraft = class_310.method_1551();
        if (minecraft == null || minecraft.field_1724 == null) {
            return;
        }
        class_746 player = minecraft.field_1724;
        if (!alwaysShow && player.method_6079().method_7909() != class_1802.field_8251 && player.method_6047().method_7909() != class_1802.field_8251) {
            return;
        }
        if (onlyShowWhenSneaking && !player.method_18276()) {
            return;
        }
        class_329 gui = minecraft.field_1705;
        class_327 font = gui.method_1756();
        class_2350 direction = player.method_5735();
        class_2338 pos = player.method_24515();
        int alpha = -603979776;
        String coords = onlyXZ ? class_1074.method_4662((String)"gui.charm.coords_only_xz", (Object[])new Object[]{pos.method_10263(), pos.method_10260()}) : class_1074.method_4662((String)"gui.charm.coords", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
        int coordsLength = font.method_1727(coords);
        int coordsColor = 0xAA9988;
        String facing = class_1074.method_4662((String)"gui.charm.facing", (Object[])new Object[]{direction.method_10151()});
        int facingLength = font.method_1727(facing);
        int facingColor = 0xFFEEDD;
        if (compactView) {
            x = 10.0f;
            y = 10.0f;
            coordsOffsetX = 0;
            facingOffsetX = 0;
            lineHeight = 9.0f;
        } else {
            x = (float)gui.field_2011 / 2.0f;
            y = 40.0f;
            facingOffsetX = -facingLength / 2;
            coordsOffsetX = -coordsLength / 2;
            lineHeight = 12.0f;
        }
        if (showFacing) {
            this.renderText(guiGraphics, font, facing, x, y, facingOffsetX, 0, facingColor | alpha);
            y += lineHeight;
        }
        if (showCoords) {
            this.renderText(guiGraphics, font, coords, x, y, coordsOffsetX, 0, coordsColor | alpha);
            y += lineHeight;
        }
        if (showBiome && (biomeRes = (class_2960)player.method_37908().method_23753(pos).method_40229().map(key -> key != null ? key.method_29177() : null, unknown -> null)) != null) {
            String biomeName = class_1074.method_4662((String)("biome." + biomeRes.method_12836() + "." + biomeRes.method_12832()), (Object[])new Object[0]);
            int biomeLength = font.method_1727(biomeName);
            int biomeColor = 0x9ACCAA;
            int biomeOffsetX = compactView ? 0 : -biomeLength / 2;
            this.renderText(guiGraphics, font, biomeName, x, y, biomeOffsetX, 0, biomeColor | alpha);
        }
    }

    private void renderText(class_332 guiGraphics, class_327 font, String text, float translateX, float translateY, int offsetX, int offsetY, int color) {
        class_4587 pose = guiGraphics.method_51448();
        pose.method_22903();
        pose.method_22904((double)translateX, (double)translateY, 0.0);
        if (compactView) {
            float scaleFactor = 0.75f;
            pose.method_22905(scaleFactor, scaleFactor, scaleFactor);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25303(font, text, offsetX, offsetY, color);
        RenderSystem.disableBlend();
        pose.method_22909();
    }
}

