/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.extra_recipes;

import java.util.ArrayList;
import java.util.List;
import svenhjol.charm.feature.extra_recipes.ExtraRecipes;
import svenhjol.charm.feature.storage_blocks.StorageBlocks;
import svenhjol.charmony.api.iface.IConditionalAdvancement;
import svenhjol.charmony.api.iface.IConditionalAdvancementProvider;
import svenhjol.charmony.api.iface.IConditionalRecipe;
import svenhjol.charmony.api.iface.IConditionalRecipeProvider;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.common.CommonLoader;

public class ExtraRecipesProviders
implements IConditionalRecipeProvider,
IConditionalAdvancementProvider {
    static final String RECIPE_PREFIX = "extra_recipes/";
    static final String ADVANCEMENT_PREFIX = "extra_recipes/recipes/";

    public List<IConditionalRecipe> getRecipeConditions() {
        return List.of(new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.rawOreBlocks;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/*from_blasting_raw_*_block");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.gildedBlackstone;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/gilded_blackstone");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.snowballs;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/snowballs_from_snow_block");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.quartz;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/quartz_from_quartz_block");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.clay;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/clay_balls_from_clay_block");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.cyanDye;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/cyan_dye");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.greenDye;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/green_dye");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.soulTorch;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/soul_torch");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.bread;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/bread");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.paper;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/paper");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                Boolean gunpowderEnabled = ExtraRecipesProviders.this.loader().get(StorageBlocks.class).map(StorageBlocks::isGunpowderEnabled).orElse(false);
                return ExtraRecipes.tntFromGunpowderBlock && gunpowderEnabled != false;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/tnt_from_gunpowder_block");
            }
        }, new IConditionalRecipe(){

            public boolean test() {
                return ExtraRecipes.bundle;
            }

            public List<String> recipes() {
                return List.of("extra_recipes/bundle");
            }
        });
    }

    public List<IConditionalAdvancement> getAdvancementConditions() {
        ArrayList<IConditionalAdvancement> advancements = new ArrayList<IConditionalAdvancement>();
        List<IConditionalRecipe> recipes = this.getRecipeConditions();
        for (final IConditionalRecipe recipe : recipes) {
            advancements.add(new IConditionalAdvancement(){

                public boolean test() {
                    return recipe.test();
                }

                public List<String> advancements() {
                    List list = recipe.recipes();
                    return list.stream().map(i -> i.replace(ExtraRecipesProviders.RECIPE_PREFIX, ExtraRecipesProviders.ADVANCEMENT_PREFIX)).toList();
                }
            });
        }
        return advancements;
    }

    private CommonLoader loader() {
        return Mods.common((String)"charm").loader();
    }
}

