/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.improved_mineshafts;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_173;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3098;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3353;
import net.minecraft.class_3443;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import svenhjol.charm.feature.improved_mineshafts.Generation;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.LevelLoadEvent;
import svenhjol.charmony.common.CommonFeature;

public class ImprovedMineshafts
extends CommonFeature {
    static final List<class_2680> FLOOR_BLOCKS = new ArrayList<class_2680>();
    static final List<class_2680> CEILING_BLOCKS = new ArrayList<class_2680>();
    static final List<class_2680> PILE_BLOCKS = new ArrayList<class_2680>();
    static final List<class_2680> ROOM_BLOCKS = new ArrayList<class_2680>();
    static final List<class_2680> ROOM_DECORATIONS = new ArrayList<class_2680>();
    static final List<class_2960> MINECART_LOOT = new ArrayList<class_2960>();
    static final class_2960 FLOOR_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/floor_blocks");
    static final class_2960 PILE_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/pile_blocks");
    static final class_2960 CEILING_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/ceiling_blocks");
    static final class_2960 ROOM_BLOCK_LOOT = new class_2960("charm", "improved_mineshafts/room_blocks");
    static final class_2960 ROOM_DECORATION_LOOT = new class_2960("charm", "improved_mineshafts/room_decorations");
    @Configurable(name="Corridor floor blocks", description="Chance (out of 1.0) of blocks such as candles and ores spawning on the floor of corridors.")
    public static double floorBlockChance = 0.03;
    @Configurable(name="Corridor ceiling blocks", description="Chance (out of 1.0) of blocks such as lanterns spawning on the ceiling of corridors.")
    public static double ceilingBlockChance = 0.02;
    @Configurable(name="Corridor block piles", description="Chance (out of 1.0) of stone, gravel and ore spawning at the entrance of corridors.")
    public static double blockPileChance = 0.2;
    @Configurable(name="Room blocks", description="Chance (out of 1.0) for a moss or precious ore block to spawn on a single block of the central mineshaft room.")
    public static double roomBlockChance = 0.25;
    @Configurable(name="Extra minecarts", description="Chance (out of 1.0) for a minecart to spawn in a corridor. Minecart loot is chosen from the 'Minecart loot tables'.")
    public static double minecartChance = 0.2;

    public String description() {
        return "Adds decoration and more ores to mineshafts.";
    }

    public void register() {
        MINECART_LOOT.addAll(List.of(class_39.field_356, class_39.field_472, class_39.field_17109, class_39.field_16751, class_39.field_17010, class_39.field_17107, class_39.field_434));
    }

    public void runWhenEnabled() {
        LevelLoadEvent.INSTANCE.handle(this::handleLevelLoad);
    }

    public static void generatePiece(class_3443 piece, class_5281 level, class_5138 accessor, class_2794 chunkGenerator, class_5819 rand, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        if (((class_3353.class_3356)piece).field_14421 == class_3098.class_3100.field_13691) {
            return;
        }
        if (piece instanceof class_3353.class_3354) {
            Generation.decorateCorridor((class_3353.class_3354)piece, level, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        } else if (piece instanceof class_3353.class_3357) {
            Generation.decorateRoom((class_3353.class_3357)piece, level, accessor, chunkGenerator, rand, box, chunkPos, blockPos);
        }
    }

    private void handleLevelLoad(MinecraftServer server, class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            class_8567.class_8568 builder = new class_8567.class_8568(level);
            FLOOR_BLOCKS.addAll(this.parseLootTable(server, builder, FLOOR_BLOCK_LOOT));
            PILE_BLOCKS.addAll(this.parseLootTable(server, builder, PILE_BLOCK_LOOT));
            CEILING_BLOCKS.addAll(this.parseLootTable(server, builder, CEILING_BLOCK_LOOT));
            ROOM_BLOCKS.addAll(this.parseLootTable(server, builder, ROOM_BLOCK_LOOT));
            ROOM_DECORATIONS.addAll(this.parseLootTable(server, builder, ROOM_DECORATION_LOOT));
        }
    }

    private List<class_2680> parseLootTable(MinecraftServer server, class_8567.class_8568 builder, class_2960 tableName) {
        class_52 lootTable = server.method_3857().getLootTable(tableName);
        ObjectArrayList items = lootTable.method_51878(builder.method_51875(class_173.field_1175));
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        for (class_1799 stack : items) {
            class_2680 state = this.getBlockStateFromItemStack(stack);
            states.add(state);
        }
        return states;
    }

    private class_2680 getBlockStateFromItemStack(class_1799 stack) {
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        class_2680 state = block.method_9564();
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            class_2689 definition = block.method_9595();
            class_2487 blockStateTag = tag.method_10562("BlockStateTag");
            for (String key : blockStateTag.method_10541()) {
                class_2769 prop = definition.method_11663(key);
                if (prop == null) continue;
                String propString = Objects.requireNonNull(blockStateTag.method_10580(key)).method_10714();
                state = class_1747.method_18083((class_2680)state, (class_2769)prop, (String)propString);
            }
        }
        return state;
    }
}

