/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.mooblooms;

import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import svenhjol.charm.CharmTags;
import svenhjol.charm.feature.mooblooms.FlowerBlockState;

public enum MoobloomType {
    ALLIUM("allium", FlowerBlockState.ALLIUM),
    AZURE_BLUET("azure_bluet", FlowerBlockState.AZURE_BLUET),
    BLUE_ORCHID("blue_orchid", FlowerBlockState.BLUE_ORCHID),
    CHERRY_BLOSSOM("cherry_blossom", FlowerBlockState.PINK_PETALS),
    CORNFLOWER("cornflower", FlowerBlockState.CORNFLOWER),
    DANDELION("dandelion", FlowerBlockState.DANDELION),
    LILY_OF_THE_VALLEY("lily_of_the_valley", FlowerBlockState.LILY_OF_THE_VALLEY),
    ORANGE_TULIP("orange_tulip", FlowerBlockState.ORANGE_TULIP),
    OXEYE_DAISY("oxeye_daisy", FlowerBlockState.OXEYE_DAISY),
    PINK_TULIP("pink_tulip", FlowerBlockState.PINK_TULIP),
    POPPY("poppy", FlowerBlockState.POPPY),
    RED_TULIP("red_tulip", FlowerBlockState.RED_TULIP),
    SUNFLOWER("sunflower", FlowerBlockState.SUNFLOWER),
    WHITE_TULIP("white_tulip", FlowerBlockState.WHITE_TULIP);

    private final String name;
    private final FlowerBlockState flower;
    private final class_2960 texture;
    public static final List<MoobloomType> COMMON_TYPES;
    public static final List<MoobloomType> RARE_TYPES;

    private MoobloomType(String name, FlowerBlockState flower) {
        this.name = name;
        this.flower = flower;
        this.texture = new class_2960("charm", "textures/entity/moobloom/" + name + ".png");
    }

    public FlowerBlockState getFlower() {
        return this.flower;
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public static MoobloomType fromName(String name) {
        for (MoobloomType value : MoobloomType.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        return ALLIUM;
    }

    public static List<MoobloomType> getTypesForPos(class_1936 level, class_2338 pos) {
        class_6880 biome = level.method_23753(pos);
        List<MoobloomType> types = biome.method_40220(CharmTags.SPAWNS_CHERRY_BLOSSOM_MOOBLOOMS) ? List.of(CHERRY_BLOSSOM) : (biome.method_40220(CharmTags.SPAWNS_SUNFLOWER_MOOBLOOMS) ? List.of(SUNFLOWER) : COMMON_TYPES);
        return types;
    }

    static {
        COMMON_TYPES = List.of(ALLIUM, AZURE_BLUET, BLUE_ORCHID, CORNFLOWER, DANDELION, LILY_OF_THE_VALLEY, ORANGE_TULIP, OXEYE_DAISY, PINK_TULIP, POPPY, RED_TULIP, WHITE_TULIP);
        RARE_TYPES = List.of(SUNFLOWER, CHERRY_BLOSSOM);
    }
}

