/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.nearby_workstations;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_747;
import net.minecraft.class_7923;
import svenhjol.charm.CharmTags;
import svenhjol.charm.feature.nearby_workstations.NearbyWorkstationsNetwork;
import svenhjol.charm.feature.nearby_workstations.menu.NearbyAnvilMenu;
import svenhjol.charm.feature.nearby_workstations.menu.NearbyCraftingMenu;
import svenhjol.charm.feature.nearby_workstations.menu.NearbyEnchantingMenu;
import svenhjol.charm.feature.nearby_workstations.menu.NearbySmithingMenu;
import svenhjol.charm.feature.nearby_workstations.menu.NearbyStonecutterMenu;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.TagHelper;

public class NearbyWorkstations
extends CommonFeature {
    static final Map<class_2248, Function<class_2338, class_3908>> MENU_PROVIDERS = new LinkedHashMap<class_2248, Function<class_2338, class_3908>>();
    static final Map<UUID, Map<class_2248, class_2338>> WORKSTATIONS_IN_RANGE = new WeakHashMap<UUID, Map<class_2248, class_2338>>();
    static final Map<UUID, Long> LAST_WORKSTATION_CHECK = new WeakHashMap<UUID, Long>();
    static final class_2561 CRAFTING_MENU_TITLE = class_2561.method_43471((String)"container.crafting");
    static final class_2561 SMITHING_MENU_TITLE = class_2561.method_43471((String)"container.upgrade");
    static final class_2561 ANVIL_MENU_TITLE = class_2561.method_43471((String)"container.repair");
    static final class_2561 STONECUTTER_MENU_TITLE = class_2561.method_43471((String)"container.stonecutter");
    static final class_2561 ENCHANTMENT_MENU_TITLE = class_2561.method_43471((String)"container.enchant");
    @Configurable(name="Distance", description="Range from which player can access a workstation.")
    public static int distance = 16;

    public String description() {
        return "Use workstations such as crafting tables when in range of the block.";
    }

    public void register() {
        NearbyWorkstationsNetwork.register();
        NearbyWorkstations.registerBlockMenu(class_2246.field_9980, pos -> new class_747((i, inv, p) -> new NearbyCraftingMenu(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515()), (class_2338)pos), CRAFTING_MENU_TITLE));
        NearbyWorkstations.registerBlockMenu(class_2246.field_16329, pos -> new class_747((i, inv, p) -> new NearbySmithingMenu(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515()), (class_2338)pos), SMITHING_MENU_TITLE));
        Function<class_2338, class_3908> anvilMenuProvider = pos -> new class_747((i, inv, p) -> new NearbyAnvilMenu(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515()), (class_2338)pos), ANVIL_MENU_TITLE);
        NearbyWorkstations.registerBlockMenu(class_2246.field_10535, anvilMenuProvider);
        NearbyWorkstations.registerBlockMenu(class_2246.field_10105, anvilMenuProvider);
        NearbyWorkstations.registerBlockMenu(class_2246.field_10414, anvilMenuProvider);
        NearbyWorkstations.registerBlockMenu(class_2246.field_16335, pos -> new class_747((i, inv, p) -> new NearbyStonecutterMenu(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515()), (class_2338)pos), STONECUTTER_MENU_TITLE));
        NearbyWorkstations.registerBlockMenu(class_2246.field_10485, pos -> new class_747((i, inv, p) -> new NearbyEnchantingMenu(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515()), (class_2338)pos), ENCHANTMENT_MENU_TITLE));
    }

    public static void registerBlockMenu(class_2248 block, Function<class_2338, class_3908> menuProvider) {
        MENU_PROVIDERS.put(block, menuProvider);
    }

    static Map<class_2248, class_2338> getWorkstationsInRange(class_1657 player) {
        UUID uuid = player.method_5667();
        class_1937 level = player.method_37908();
        long gametime = level.method_8510();
        class_2338 pos = player.method_24515();
        if (!LAST_WORKSTATION_CHECK.containsKey(uuid) || LAST_WORKSTATION_CHECK.get(uuid) < gametime - 10L || !WORKSTATIONS_IN_RANGE.containsKey(uuid)) {
            LinkedHashMap workstations = new LinkedHashMap();
            TagHelper.getValues((class_2378)class_7923.field_41175, CharmTags.NEARBY_WORKSTATIONS).forEach(workstation -> {
                Set existingBlocks = workstations.keySet();
                Optional result = class_2338.method_25997((class_2338)pos, (int)distance, (int)distance, p -> level.method_8320(p).method_27852(workstation));
                result.ifPresent(blockPos -> {
                    if (workstation.method_9564().method_26164(class_3481.field_15486)) {
                        for (class_2248 existing : existingBlocks) {
                            if (!existing.method_9564().method_26164(class_3481.field_15486)) continue;
                            return;
                        }
                    }
                    workstations.put(workstation, blockPos);
                });
            });
            WORKSTATIONS_IN_RANGE.remove(uuid);
            WORKSTATIONS_IN_RANGE.put(uuid, workstations);
            LAST_WORKSTATION_CHECK.put(uuid, gametime);
        }
        return WORKSTATIONS_IN_RANGE.getOrDefault(uuid, new HashMap());
    }

    static void handleOpenedSelector(NearbyWorkstationsNetwork.OpenWorkstationSelector message, class_1657 player) {
        Map<class_2248, class_2338> workstations = NearbyWorkstations.getWorkstationsInRange(player);
        LinkedList<class_2248> blocks = new LinkedList<class_2248>(workstations.keySet());
        Mods.common((String)"charm").log().debug(NearbyWorkstations.class, "There are " + blocks.size() + " block(s) in range", new Object[0]);
        if (blocks.size() == 1) {
            class_2248 block = blocks.get(0);
            class_2338 position = workstations.get(block);
            NearbyWorkstations.openContainer((class_3222)player, block, position);
        } else if (blocks.size() > 1) {
            NearbyWorkstations.openSelector((class_3222)player, blocks);
        }
    }

    static void handleOpenedSpecificWorkstation(NearbyWorkstationsNetwork.OpenSpecificWorkstation message, class_1657 player) {
        Map<class_2248, class_2338> workstations = NearbyWorkstations.getWorkstationsInRange(player);
        class_2248 workstation = message.getWorkstation();
        class_2338 position = workstations.get(workstation);
        NearbyWorkstations.openContainer((class_3222)player, workstation, position);
    }

    static void openSelector(class_3222 player, List<class_2248> workstations) {
        player.method_7346();
        NearbyWorkstationsNetwork.OpenWorkstationSelectorScreen.send((class_1657)player, workstations);
    }

    static void openContainer(class_3222 player, class_2248 block, class_2338 pos) {
        Mods.common((String)"charm").log().debug(NearbyWorkstations.class, "Going to try and open a workstation for " + String.valueOf(block), new Object[0]);
        if (MENU_PROVIDERS.containsKey(block)) {
            player.method_7346();
            Function<class_2338, class_3908> provider = MENU_PROVIDERS.get(block);
            player.method_17355(provider.apply(pos));
            if (block == class_2246.field_9980) {
                NearbyWorkstations.triggerUsedProximityCraftingTable((class_1657)player);
            }
        }
    }

    static void triggerUsedProximityCraftingTable(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "used_nearby_crafting_table"), (class_1657)player);
    }
}

