/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.pigs_find_mushrooms;

import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1452;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import svenhjol.charm.feature.pigs_find_mushrooms.FindMushroomGoal;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.event.EntityJoinEvent;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.PlayerHelper;

public class PigsFindMushrooms
extends CommonFeature {
    public static final WeakHashMap<UUID, Integer> PIG_ANIMATION_TICKS = new WeakHashMap();
    public static Supplier<class_3414> sniffingSound;
    @Configurable(name="Chance to find mushroom", description="Approximately 1 in X chance of a pig finding a mushroom per game tick.", requireRestart=false)
    public static int findChance;
    @Configurable(name="Chance to erode block", description="Chance (out of 1.0) of a block being converted to dirt when a pig finds a mushroom.", requireRestart=false)
    public static double erodeChance;

    public String description() {
        return "Pigs have a chance to find mushrooms from mycelium and podzol blocks.";
    }

    public void register() {
        sniffingSound = this.mod().registry().soundEvent("pig_sniffing");
    }

    public void runWhenEnabled() {
        EntityJoinEvent.INSTANCE.handle(this::handleEntityJoin);
    }

    private void handleEntityJoin(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1452) {
            class_1452 pig = (class_1452)entity;
            class_1355 goalSelector = pig.field_6201;
            if (goalSelector.method_35115().stream().noneMatch(g -> g.method_19058() instanceof FindMushroomGoal)) {
                goalSelector.method_6277(3, (class_1352)new FindMushroomGoal(pig));
            }
        }
    }

    public static float getHeadEatPositionScale(class_1452 pig, float f) {
        Integer tick = PIG_ANIMATION_TICKS.getOrDefault(pig.method_5667(), 0);
        if (tick <= 0) {
            return 0.0f;
        }
        if (tick >= 4 && tick <= 36) {
            return 1.0f;
        }
        if (tick < 4) {
            return ((float)tick.intValue() - f) / 4.0f;
        }
        return -((float)(tick - 40) - f) / 4.0f;
    }

    public static float getHeadEatAngleScale(class_1452 pig, float f) {
        Integer tick = PIG_ANIMATION_TICKS.getOrDefault(pig.method_5667(), 0);
        if (tick > 4 && tick <= 36) {
            float g = ((float)(tick - 4) - f) / 32.0f;
            return 0.63f + 0.22f * class_3532.method_15374((float)(g * 28.7f));
        }
        if (tick > 0) {
            return 0.63f;
        }
        return pig.method_36455() * ((float)Math.PI / 180);
    }

    public static void triggerUnearthedMushroom(class_1937 level, class_2338 pos) {
        PlayerHelper.getPlayersInRange((class_1937)level, (class_2338)pos, (double)8.0).forEach(player -> Advancements.trigger((class_2960)new class_2960("charm", "unearthed_mushroom"), (class_1657)player));
    }

    static {
        findChance = 1000;
        erodeChance = 0.25;
    }
}

