/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.quick_replant;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2242;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2271;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2439;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_8237;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.event.BlockUseEvent;
import svenhjol.charmony.api.iface.IQuickReplantProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.ApiHelper;
import svenhjol.charmony.helper.CharmonyEnchantmentHelper;

public class QuickReplant
extends CommonFeature
implements IQuickReplantProvider {
    static final List<class_2680> REPLANTABLE = new ArrayList<class_2680>();
    static final List<class_2248> NOT_REPLANTABLE = List.of(class_2246.field_42734, class_2246.field_43228, class_2246.field_43229);

    public String description() {
        return "Right-click with a hoe to quickly harvest and replant a fully-grown crop.";
    }

    public void register() {
        ApiHelper.consume(IQuickReplantProvider.class, provider -> provider.getHarvestableBlocks().forEach(supplier -> REPLANTABLE.add((class_2680)supplier.get())));
        CharmonyApi.registerProvider((Object)((Object)this));
    }

    public void runWhenEnabled() {
        BlockUseEvent.INSTANCE.handle(this::handleBlockUse);
    }

    private class_1269 handleBlockUse(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        boolean doReplant;
        class_1799 held;
        class_1799 mainhand = player.method_6047();
        class_1799 offhand = player.method_6079();
        if (mainhand.method_7909() instanceof class_1794) {
            held = mainhand;
        } else if (offhand.method_7909() instanceof class_1794) {
            held = offhand;
        } else {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        boolean bl = doReplant = !NOT_REPLANTABLE.contains(block);
        if (!REPLANTABLE.contains(state)) {
            return class_1269.field_5811;
        }
        class_1792 blockItem = block.method_8389();
        class_2680 newState = block.method_9564();
        for (class_2769 prop : state.method_28501()) {
            if (!prop.method_11899().toLowerCase(Locale.ENGLISH).equals("facing")) continue;
            newState = (class_2680)newState.method_11657(prop, state.method_11654(prop));
            break;
        }
        if (!level.field_9236) {
            class_3222 serverPlayer = (class_3222)player;
            class_3218 serverLevel = (class_3218)serverPlayer.method_37908();
            List drops = class_2248.method_9609((class_2680)state, (class_3218)serverLevel, (class_2338)pos, null, (class_1297)player, (class_1799)class_1799.field_8037);
            boolean hasCollection = this.mod().loader().isEnabled("Collection") && CharmonyEnchantmentHelper.itemHasEnchantment((class_1799)held, (class_2960)this.mod().id("collection"));
            for (class_1799 drop : drops) {
                if (doReplant && drop.method_7909() == blockItem) {
                    drop.method_7934(1);
                }
                if (drop.method_7960()) continue;
                if (hasCollection) {
                    player.method_31548().method_7398(drop);
                    continue;
                }
                class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)drop);
            }
            if (!doReplant) {
                newState = class_2246.field_10124.method_9564();
            }
            level.method_8474(2001, pos, class_2248.method_9507((class_2680)newState));
            level.method_8501(pos, newState);
            level.method_8396(null, pos, class_3417.field_17610, class_3419.field_15245, 1.0f, 1.0f);
            QuickReplant.triggerReplantedCrops((class_1657)serverPlayer);
            if (!player.method_31549().field_7477) {
                held.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    public List<Supplier<class_2680>> getHarvestableBlocks() {
        ArrayList<Supplier<class_2680>> harvestables = new ArrayList<Supplier<class_2680>>(List.of(() -> (class_2680)class_2246.field_10341.method_9564().method_11657((class_2769)class_2242.field_9962, (Comparable)Integer.valueOf(3)), () -> (class_2680)class_2246.field_10609.method_9564().method_11657((class_2769)class_2271.field_10835, (Comparable)Integer.valueOf(7)), () -> (class_2680)class_2246.field_9974.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(3)), () -> (class_2680)class_2246.field_10247.method_9564().method_11657((class_2769)class_2439.field_10835, (Comparable)Integer.valueOf(7)), () -> (class_2680)class_2246.field_10293.method_9564().method_11657((class_2769)class_2302.field_10835, (Comparable)Integer.valueOf(7)), () -> (class_2680)class_2246.field_43228.method_9564().method_11657((class_2769)class_8237.field_43239, (Comparable)Integer.valueOf(4)), () -> class_2246.field_43229.method_9564(), () -> class_2246.field_42734.method_9564()));
        class_2246.field_10302.method_9595().method_11662().stream().filter(s -> (Integer)s.method_11654((class_2769)class_2282.field_10779) == 2).forEach(s -> harvestables.add(() -> s));
        return harvestables;
    }

    public static void triggerReplantedCrops(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "replanted_crops"), (class_1657)player);
    }
}

