/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.storage_blocks.sugar;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import svenhjol.charm.feature.storage_blocks.IStorageBlockFeature;
import svenhjol.charm.feature.storage_blocks.StorageBlocks;
import svenhjol.charm.feature.storage_blocks.sugar.SugarBlock;
import svenhjol.charmony.api.enums.EventResult;
import svenhjol.charmony.api.event.SugarDissolveEvent;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.PlayerHelper;
import svenhjol.charmony.iface.ICommonRegistry;

public class Sugar
implements IStorageBlockFeature<ICommonRegistry> {
    private static final String ID = "sugar_block";
    static Supplier<class_2248> block;
    static Supplier<class_1792> item;
    static Supplier<class_3414> dissolveSound;
    static boolean enabled;
    ICommonRegistry registry;

    @Override
    public List<BooleanSupplier> checks() {
        return List.of(() -> StorageBlocks.sugarEnabled);
    }

    @Override
    public void preRegister(ICommonRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void register() {
        block = this.registry.block(ID, SugarBlock::new);
        item = this.registry.item(ID, SugarBlock.BlockItem::new);
        dissolveSound = this.registry.soundEvent("sugar_dissolve");
        enabled = this.checks().stream().allMatch(BooleanSupplier::getAsBoolean);
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    @Override
    public void runWhenEnabled() {
        SugarDissolveEvent.INSTANCE.handle(this::handleSugarDissolve, 0);
    }

    private EventResult handleSugarDissolve(class_1937 level, class_2338 pos) {
        level.method_8650(pos, true);
        level.method_8396(null, pos, dissolveSound.get(), class_3419.field_15245, 1.0f, 1.0f);
        return EventResult.PASS;
    }

    static void triggerDissolvedSugar(class_3218 level, class_2338 pos) {
        PlayerHelper.getPlayersInRange((class_1937)level, (class_2338)pos, (double)8.0).forEach(player -> Advancements.trigger((class_2960)new class_2960("charm", "dissolved_sugar"), (class_1657)player));
    }
}

