/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.totem_of_preserving;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5632;
import svenhjol.charm.feature.totem_of_preserving.TotemOfPreserving;
import svenhjol.charm.feature.totem_of_preserving.TotemOfPreservingTooltip;
import svenhjol.charmony.base.CharmonyItem;
import svenhjol.charmony.base.Mods;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.feature.colored_glints.ColoredGlints;
import svenhjol.charmony.helper.ClientEffectHelper;
import svenhjol.charmony.helper.ItemNbtHelper;
import svenhjol.charmony.helper.TextHelper;
import svenhjol.charmony.helper.TotemHelper;
import svenhjol.charmony.iface.ILog;

public class TotemItem
extends CharmonyItem {
    static final String MESSAGE_TAG = "message";
    static final String ITEMS_TAG = "items";
    static final String GLINT_TAG = "glint";

    public TotemItem(CommonFeature feature) {
        super(feature, new class_1792.class_1793().method_7889(1).method_7895(TotemOfPreserving.durability).method_7894(class_1814.field_8907));
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7886(class_1799 stack) {
        return TotemItem.hasGlint(stack);
    }

    public boolean method_7878(class_1799 item, class_1799 repair) {
        return TotemOfPreserving.durability > 1 && !TotemOfPreserving.graveMode && (repair.method_31574(class_1802.field_38746) || super.method_7878(item, repair));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 totem = player.method_5998(hand);
        class_2338 pos = player.method_24515();
        boolean destroyTotem = false;
        if (!TotemItem.hasItems(totem)) {
            class_1799 newTotem = this.givePlayerCleanTotem(player, hand);
            newTotem.method_7974(totem.method_7919());
            return class_1271.method_22430((Object)newTotem);
        }
        List<class_1799> items = TotemItem.getItems(totem);
        level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 0.6f, 1.0f);
        if (TotemOfPreserving.graveMode) {
            destroyTotem = true;
        } else if (TotemOfPreserving.durability <= 0) {
            this.givePlayerCleanTotem(player, hand);
        } else {
            int damage = totem.method_7919();
            if (damage < totem.method_7936() && totem.method_7936() - damage > 1) {
                class_1799 newTotem = this.givePlayerCleanTotem(player, hand);
                newTotem.method_7974(damage + 1);
            } else {
                destroyTotem = true;
            }
        }
        if (!destroyTotem) {
            level.method_8396(null, pos, TotemOfPreserving.releaseSound.get(), class_3419.field_15248, 0.8f, 1.0f);
        } else {
            this.destroyTotem(totem, player);
        }
        if (!level.field_9236) {
            for (class_1799 stack : items) {
                class_1542 itemEntity = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264() + 0.5, (double)pos.method_10260(), stack);
                level.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_7836(level, player, hand);
    }

    private void destroyTotem(class_1799 stack, class_1657 player) {
        if (!player.method_37908().field_9236) {
            TotemHelper.destroy((class_1657)player, (class_1799)stack);
        } else {
            ClientEffectHelper.destroyTotem((class_2338)player.method_24515());
        }
    }

    private class_1799 givePlayerCleanTotem(class_1657 player, class_1268 hand) {
        class_1799 stack = new class_1799((class_1935)TotemOfPreserving.item.get());
        player.method_6122(hand, stack);
        return stack;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltip, class_1836 context) {
        String message = TotemItem.getMessage(stack);
        List<class_1799> items = TotemItem.getItems(stack);
        if (!message.isEmpty()) {
            tooltip.add((class_2561)TextHelper.literal((String)message));
        }
        if (!items.isEmpty()) {
            int size = items.size();
            String str = size == 1 ? "totem_of_preserving.charm.item" : "totem_of_preserving.charm.items";
            tooltip.add((class_2561)TextHelper.literal((String)class_1074.method_4662((String)str, (Object[])new Object[]{size})));
        }
        super.method_7851(stack, level, tooltip, context);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        List<class_1799> heldItems = TotemItem.getItems(stack);
        if (heldItems.isEmpty()) {
            return Optional.empty();
        }
        class_2371 items = class_2371.method_10211();
        items.addAll(heldItems);
        return Optional.of(new TotemOfPreservingTooltip((class_2371<class_1799>)items));
    }

    public static void setMessage(class_1799 totem, String message) {
        ItemNbtHelper.setString((class_1799)totem, (String)MESSAGE_TAG, (String)message);
    }

    public static void setItems(class_1799 totem, List<class_1799> items) {
        class_2487 serialized = new class_2487();
        for (int i = 0; i < items.size(); ++i) {
            class_1799 stack = items.get(i);
            if (stack.method_7960()) continue;
            serialized.method_10566(Integer.toString(i), (class_2520)stack.method_7953(new class_2487()));
        }
        ItemNbtHelper.setCompound((class_1799)totem, (String)ITEMS_TAG, (class_2487)serialized);
    }

    public static void setGlint(class_1799 totem, boolean flag) {
        ItemNbtHelper.setBoolean((class_1799)totem, (String)GLINT_TAG, (boolean)flag);
        ColoredGlints.applyColoredGlint((class_1799)totem, (class_1767)class_1767.field_7955);
    }

    public static void setTotemDamage(class_1799 totem, int damage) {
        totem.method_7974(damage);
    }

    public static String getMessage(class_1799 totem) {
        return ItemNbtHelper.getString((class_1799)totem, (String)MESSAGE_TAG, (String)"");
    }

    public static List<class_1799> getItems(class_1799 totem) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        ILog log = Mods.common((String)"charm").log();
        class_2487 itemsTag = ItemNbtHelper.getCompound((class_1799)totem, (String)ITEMS_TAG);
        Set keys = itemsTag.method_10541();
        for (String key : keys) {
            class_2520 tag = itemsTag.method_10580(key);
            if (tag == null) {
                log.warn(TotemItem.class, "Missing item with key " + key, new Object[0]);
                continue;
            }
            class_1799 stack = class_1799.method_7915((class_2487)((class_2487)tag));
            if (stack.method_7960()) continue;
            items.add(stack);
        }
        return items;
    }

    public static boolean hasItems(class_1799 totem) {
        return !TotemItem.getItems(totem).isEmpty();
    }

    public static boolean hasGlint(class_1799 totem) {
        return ItemNbtHelper.getBoolean((class_1799)totem, (String)GLINT_TAG, (boolean)TotemItem.hasItems(totem));
    }
}

