/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.feature.totem_of_preserving;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import svenhjol.charm.feature.totem_of_preserving.TotemBlock;
import svenhjol.charm.feature.totem_of_preserving.TotemBlockEntity;
import svenhjol.charm.feature.totem_of_preserving.TotemDataProviders;
import svenhjol.charm.feature.totem_of_preserving.TotemItem;
import svenhjol.charm.feature.totems_work_from_inventory.TotemsWorkFromInventory;
import svenhjol.charmony.annotation.Configurable;
import svenhjol.charmony.api.CharmonyApi;
import svenhjol.charmony.api.enums.TotemType;
import svenhjol.charmony.api.event.AnvilUpdateEvent;
import svenhjol.charmony.api.event.PlayerInventoryDropEvent;
import svenhjol.charmony.api.iface.ITotemInventoryCheckProvider;
import svenhjol.charmony.api.iface.ITotemPreservingProvider;
import svenhjol.charmony.common.CommonFeature;
import svenhjol.charmony.common.CommonLoader;
import svenhjol.charmony.feature.advancements.Advancements;
import svenhjol.charmony.helper.ApiHelper;
import svenhjol.charmony.helper.TextHelper;
import svenhjol.charmony.iface.ICommonRegistry;
import svenhjol.charmony.iface.ILog;

public class TotemOfPreserving
extends CommonFeature {
    static Supplier<class_1792> item;
    static Supplier<class_2248> block;
    static Supplier<class_2591<TotemBlockEntity>> blockEntity;
    static Supplier<class_3414> releaseSound;
    static Supplier<class_3414> storeSound;
    static List<ITotemPreservingProvider> preservingProviders;
    static List<ITotemInventoryCheckProvider> inventoryCheckProviders;
    public static Map<class_2960, List<class_2338>> PROTECT_POSITIONS;
    @Configurable(name="Grave mode", description="If true, a totem of preserving will always be created when you die.\nIf false, you must be holding a totem of preserving to preserve your items on death.")
    public static boolean graveMode;
    @Configurable(name="Durability", description="The maximum number of times a single totem can be used. Once a totem runs out of uses it is destroyed.\nA value of -1 means that the totem is never destroyed.\nYou can add an echo shard on an anvil to increase the durability of the totem.\nNote: Durability has no effect if 'Grave mode' is enabled.")
    public static int durability;
    @Configurable(name="Owner only", description="If true, only the owner of the totem may pick it up.", requireRestart=false)
    public static boolean ownerOnly;
    @Configurable(name="Show death position", description="If true, the coordinates where you died will be added to the player's chat screen.", requireRestart=false)
    public static boolean showDeathPositionInChat;

    public String description() {
        return "Preserves your items on death.";
    }

    public void register() {
        ICommonRegistry registry = this.mod().registry();
        block = registry.block("totem_of_preserving_holder", () -> new TotemBlock(this));
        blockEntity = registry.blockEntity("totem_block", () -> TotemBlockEntity::new, List.of(block));
        item = registry.item("totem_of_preserving", () -> new TotemItem(this));
        releaseSound = registry.soundEvent("totem_release_items");
        storeSound = registry.soundEvent("totem_store_items");
        CharmonyApi.registerProvider((Object)new TotemDataProviders());
    }

    public void runWhenEnabled() {
        ApiHelper.consume(ITotemPreservingProvider.class, provider -> preservingProviders.add((ITotemPreservingProvider)provider));
        ApiHelper.consume(ITotemInventoryCheckProvider.class, provider -> inventoryCheckProviders.add((ITotemInventoryCheckProvider)provider));
        PlayerInventoryDropEvent.INSTANCE.handle(this::handlePlayerInventoryDrop);
        AnvilUpdateEvent.INSTANCE.handle(this::handleAnvilUpdate);
    }

    private Optional<AnvilUpdateEvent.AnvilRecipe> handleAnvilUpdate(class_1657 player, class_1799 input, class_1799 material, int cost) {
        if (input.method_31574(item.get()) && input.method_7986() && material.method_31574(class_1802.field_38746)) {
            AnvilUpdateEvent.AnvilRecipe recipe = new AnvilUpdateEvent.AnvilRecipe();
            recipe.output = input.method_7972();
            recipe.output.method_7974(input.method_7919() - 1);
            recipe.experienceCost = 1;
            recipe.materialCost = 1;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    private class_1269 handlePlayerInventoryDrop(class_1657 player, class_1661 inventory) {
        boolean result;
        if (player.method_37908().field_9236) {
            return class_1269.field_5811;
        }
        class_1799 found = class_1799.field_8037;
        int damage = 0;
        ILog log = this.mod().log();
        CommonLoader loader = this.mod().loader();
        class_3222 serverPlayer = (class_3222)player;
        ArrayList<class_1799> preserveItems = new ArrayList<class_1799>();
        for (ITotemPreservingProvider provider : preservingProviders) {
            preserveItems.addAll(provider.getInventoryItemsForTotem(player).stream().filter(i -> !i.method_7960()).toList());
        }
        if (!graveMode) {
            boolean totemWorksFromInventory = loader.isEnabled(TotemsWorkFromInventory.class);
            if (!totemWorksFromInventory) {
                for (class_1799 class_17992 : player.method_5877()) {
                    if (!class_17992.method_31574(item.get()) || TotemItem.hasItems(class_17992)) continue;
                    log.debug(((Object)((Object)this)).getClass(), "Found totem in hand", new Object[0]);
                    damage = class_17992.method_7919();
                    found = class_17992;
                    break;
                }
            } else {
                for (ITotemInventoryCheckProvider iTotemInventoryCheckProvider : inventoryCheckProviders) {
                    Optional item = iTotemInventoryCheckProvider.findTotemFromInventory(player, TotemType.PRESERVING);
                    if (!item.isPresent()) continue;
                    log.debug(((Object)((Object)this)).getClass(), "Found totem in inventory", new Object[0]);
                    found = (class_1799)item.get();
                    damage = found.method_7919();
                    break;
                }
            }
            if (found.method_7960()) {
                log.debug(((Object)((Object)this)).getClass(), "Could not find an empty totem, giving up", new Object[0]);
                return class_1269.field_5811;
            }
            if (preserveItems.isEmpty() || preserveItems.size() == 1) {
                log.debug(((Object)((Object)this)).getClass(), "No items to store in totem (graveMode = false), giving up", new Object[0]);
                return class_1269.field_5811;
            }
        }
        if (preserveItems.isEmpty()) {
            log.debug(((Object)((Object)this)).getClass(), "No items to store in totem (graveMode = true), giving up", new Object[0]);
            return class_1269.field_5811;
        }
        if (!found.method_7960()) {
            found.method_7934(found.method_7947());
        }
        if (!(result = this.tryCreateTotemBlock(serverPlayer, preserveItems, damage))) {
            return class_1269.field_5811;
        }
        for (ITotemPreservingProvider iTotemPreservingProvider : preservingProviders) {
            iTotemPreservingProvider.deleteInventoryItems(player);
        }
        return class_1269.field_5812;
    }

    private boolean tryCreateTotemBlock(class_3222 player, List<class_1799> preserve, int damage) {
        int tries;
        int minHeight;
        int maxHeight;
        class_2338 spawnPos;
        class_2338 pos;
        String message;
        UUID uuid;
        class_5819 random;
        class_1937 level;
        ILog log;
        block10: {
            block11: {
                int y;
                class_3610 fluid;
                block9: {
                    log = this.mod().log();
                    level = player.method_37908();
                    random = player.method_6051();
                    uuid = player.method_5667();
                    message = player.method_5820();
                    pos = player.method_24515();
                    class_1297 vehicle = player.method_5854();
                    if (vehicle != null) {
                        pos = vehicle.method_24515();
                    }
                    spawnPos = null;
                    maxHeight = level.method_31600() - 1;
                    minHeight = level.method_31607() + 1;
                    class_2680 state = level.method_8320(pos);
                    fluid = level.method_8316(pos);
                    if (pos.method_10264() < minHeight) {
                        pos = new class_2338(pos.method_10263(), level.method_8615(), pos.method_10260());
                        log.debug(((Object)((Object)this)).getClass(), "(Void check) Adjusting, new pos: " + String.valueOf(pos), new Object[0]);
                    }
                    if (!state.method_26215() && !fluid.method_15767(class_3486.field_15517)) break block9;
                    log.debug(((Object)((Object)this)).getClass(), "(Standard check) Found an air/water block to spawn in: " + String.valueOf(pos), new Object[0]);
                    spawnPos = pos;
                    break block10;
                }
                if (!fluid.method_15767(class_3486.field_15518)) break block11;
                for (tries = 0; tries < 20 && (y = pos.method_10264() + tries) < maxHeight; ++tries) {
                    class_2338 tryPos = new class_2338(pos.method_10263(), y, pos.method_10260());
                    class_2680 tryState = level.method_8320(tryPos);
                    class_3610 tryFluid = level.method_8316(tryPos);
                    if (tryFluid.method_15767(class_3486.field_15518)) continue;
                    if (!tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) break;
                    log.debug(((Object)((Object)this)).getClass(), "(Lava check) Found an air/water block to spawn in after checking " + tries + " times: " + String.valueOf(pos), new Object[0]);
                    spawnPos = tryPos;
                    break;
                }
                if (spawnPos != null) break block10;
                log.debug(((Object)((Object)this)).getClass(), "(Lava check) Going to replace lava with totem at: " + String.valueOf(pos), new Object[0]);
                spawnPos = pos;
                break block10;
            }
            List<class_2350> directions = Arrays.asList(class_2350.field_11036, class_2350.field_11034, class_2350.field_11043, class_2350.field_11039, class_2350.field_11035);
            for (class_2350 direction : directions) {
                class_2338 tryPos = pos.method_10093(direction);
                class_2680 tryState = level.method_8320(tryPos);
                class_3610 tryFluid = level.method_8316(tryPos);
                if (tryPos.method_10264() >= maxHeight || !tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) continue;
                log.debug(((Object)((Object)this)).getClass(), "(Solid check) Found an air/water block to spawn in, direction: " + String.valueOf(direction) + ", pos: " + String.valueOf(pos), new Object[0]);
                spawnPos = tryPos;
                break;
            }
        }
        if (spawnPos == null) {
            for (tries = 0; tries < 8; ++tries) {
                int x = pos.method_10263() + random.method_43048(tries + 1) - tries;
                int z = pos.method_10260() + random.method_43048(tries + 1) - tries;
                int y = pos.method_10264() + tries;
                if (y > maxHeight && (y = pos.method_10264() - tries) < minHeight) continue;
                class_2338 tryPos = new class_2338(x, y, z);
                class_2680 tryState = level.method_8320(tryPos);
                class_3610 tryFluid = level.method_8316(tryPos);
                if (!tryState.method_26215() && !tryFluid.method_15767(class_3486.field_15517)) continue;
                log.debug(((Object)((Object)this)).getClass(), "(Distance check) Found an air/water block to spawn in after checking " + tries + " times: " + String.valueOf(pos), new Object[0]);
                spawnPos = tryPos;
                break;
            }
        }
        if (spawnPos == null) {
            log.debug(((Object)((Object)this)).getClass(), "Could not find a block to spawn totem, giving up.", new Object[0]);
            return false;
        }
        level.method_8501(spawnPos, block.get().method_9564());
        class_2586 x = level.method_8321(spawnPos);
        if (!(x instanceof TotemBlockEntity)) {
            log.debug(((Object)((Object)this)).getClass(), "Not a valid block entity at pos, giving up. Pos: " + String.valueOf(pos), new Object[0]);
            return false;
        }
        TotemBlockEntity totem = (TotemBlockEntity)x;
        totem.setItems(preserve);
        totem.setMessage(message);
        totem.setOwner(uuid);
        totem.setDamage(damage);
        totem.method_5431();
        PROTECT_POSITIONS.computeIfAbsent(level.method_27983().method_29177(), a -> new ArrayList()).add(spawnPos);
        log.info(((Object)((Object)this)).getClass(), "Spawned a totem at: " + String.valueOf(spawnPos), new Object[0]);
        TotemOfPreserving.triggerUsedTotemOfPreserving((class_1657)player);
        level.method_8396(null, spawnPos, storeSound.get(), class_3419.field_15248, 1.0f, 1.0f);
        if (showDeathPositionInChat) {
            int x2 = spawnPos.method_10263();
            int y = spawnPos.method_10264();
            int z = spawnPos.method_10260();
            player.method_7353((class_2561)TextHelper.translatable((String)"gui.charm.totem_of_preserving.death_position", (Object[])new Object[]{x2, y, z}), false);
        }
        return true;
    }

    public static void triggerUsedTotemOfPreserving(class_1657 player) {
        Advancements.trigger((class_2960)new class_2960("charm", "used_totem_of_preserving"), (class_1657)player);
    }

    static {
        preservingProviders = new ArrayList<ITotemPreservingProvider>();
        inventoryCheckProviders = new ArrayList<ITotemInventoryCheckProvider>();
        PROTECT_POSITIONS = new HashMap<class_2960, List<class_2338>>();
        graveMode = false;
        durability = 3;
        ownerOnly = false;
        showDeathPositionInChat = false;
    }
}

