/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.mixin;

import com.google.common.base.CaseFormat;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import svenhjol.charmony.helper.ConfigHelper;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    protected String mixinPackage;
    protected static final Logger LOGGER = LogManager.getLogger((String)"MixinConfig");
    protected static final Map<String, Boolean> BLACKLISTED = new HashMap<String, Boolean>();
    protected static final List<String> ALL_MIXINS = new ArrayList<String>();

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        String blacklist = this.getBlacklistPath();
        File blacklistFile = new File(blacklist);
        if (blacklistFile.exists()) {
            try {
                FileInputStream stream = new FileInputStream(blacklist);
                Scanner scanner = new Scanner(stream);
                while (scanner.hasNextLine()) {
                    BLACKLISTED.put(scanner.nextLine(), true);
                }
                scanner.close();
                stream.close();
            }
            catch (Exception var6) {
                LOGGER.warn("IO error when handling mixin blacklist: " + var6.getMessage());
            }
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean valid;
        String simpleName = mixinClassName.substring(this.mixinPackage.length() + 1);
        String featureName = MixinConfigPlugin.snakeToUpperCamel(simpleName.substring(0, simpleName.indexOf(".")));
        boolean debug = ConfigHelper.isDebugEnabled();
        for (Predicate<String> predicate : this.runtimeBlacklist()) {
            boolean isBlacklisted = predicate.test(featureName);
            BLACKLISTED.put(simpleName, BLACKLISTED.getOrDefault(simpleName, false) != false || isBlacklisted);
        }
        if (!ALL_MIXINS.contains(simpleName)) {
            ALL_MIXINS.add(simpleName);
        }
        if (ConfigHelper.isCompatEnabled() && !simpleName.startsWith("accessor")) {
            LOGGER.warn("Compat mode skipping mixin " + mixinClassName);
            return false;
        }
        if (BLACKLISTED.containsKey(simpleName) && BLACKLISTED.get(simpleName).booleanValue()) {
            LOGGER.warn("Blacklisted mixin " + mixinClassName);
            return false;
        }
        String common = ConfigHelper.getFilename((String)this.modId(), (ConfigHelper.Side)ConfigHelper.Side.COMMON);
        String client = ConfigHelper.getFilename((String)this.modId(), (ConfigHelper.Side)ConfigHelper.Side.CLIENT);
        boolean enabledInCommon = ConfigHelper.isFeatureEnabled((String)common, (String)featureName);
        boolean enabledInClient = ConfigHelper.isFeatureEnabled((String)client, (String)featureName);
        boolean bl = valid = enabledInCommon && enabledInClient;
        if (debug) {
            if (valid) {
                LOGGER.info("Enabled mixin " + mixinClassName);
            } else {
                LOGGER.info("Disabled mixin " + mixinClassName);
            }
        }
        return valid;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    protected String modId() {
        return "charm";
    }

    protected String getBlacklistPath() {
        Path var10000 = ConfigHelper.getConfigDir();
        return String.valueOf(var10000) + "/" + this.modId() + "-mixin-blacklist.txt";
    }

    protected List<Predicate<String>> runtimeBlacklist() {
        return List.of(feature -> feature.equals("ColoredGlintSmithingTemplates") && ConfigHelper.isModLoaded((String)"optifabric"), feature -> feature.equals("NoChatUnverifiedMessage") && ConfigHelper.isModLoaded((String)"chatsigninghider"), feature -> feature.equals("ExtraStackables") && ConfigHelper.isModLoaded((String)"allstackable"), feature -> feature.equals("PigsFindMushrooms") && (ConfigHelper.isModLoaded((String)"twilightforest") || ConfigHelper.isModLoaded((String)"aether")), feature -> (feature.equals("UnlimitedRepairCost") || feature.equals("ShowRepairCost") || feature.equals("StrongerAnvils")) && ConfigHelper.isModLoaded((String)"zenith"));
    }

    public static String snakeToUpperCamel(String string) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, string);
    }
}

