/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.api.BankingService;
import me.koyere.ecoxpert.api.EcoXpertAPI;
import me.koyere.ecoxpert.api.EconomyService;
import me.koyere.ecoxpert.api.EventsService;
import me.koyere.ecoxpert.api.InflationService;
import me.koyere.ecoxpert.api.LoanService;
import me.koyere.ecoxpert.api.MarketService;
import me.koyere.ecoxpert.api.ProfessionService;
import me.koyere.ecoxpert.api.dto.CycleForecast;
import me.koyere.ecoxpert.api.dto.PlayerEconomyView;
import me.koyere.ecoxpert.api.dto.ServerEconomySnapshot;
import me.koyere.ecoxpert.api.services.BankingServiceImpl;
import me.koyere.ecoxpert.api.services.EconomyServiceImpl;
import me.koyere.ecoxpert.api.services.EventsServiceImpl;
import me.koyere.ecoxpert.api.services.InflationServiceImpl;
import me.koyere.ecoxpert.api.services.LoanServiceImpl;
import me.koyere.ecoxpert.api.services.MarketServiceImpl;
import me.koyere.ecoxpert.api.services.ProfessionServiceImpl;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.bank.BankManager;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;
import me.koyere.ecoxpert.modules.inflation.EconomicMemory;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.inflation.PlayerEconomicProfile;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.MarketStatistics;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.configuration.file.FileConfiguration;

@Singleton
public class EcoXpertAPIImpl
implements EcoXpertAPI {
    private final EcoXpertPlugin plugin;

    @Inject
    public EcoXpertAPIImpl(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getAPIVersion() {
        return "1.0.0";
    }

    @Override
    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public boolean isReady() {
        return this.plugin.isEnabled();
    }

    @Override
    public EconomyService getEconomyService() {
        try {
            EconomyManager economyManager = this.plugin.getServiceRegistry().getInstance(EconomyManager.class);
            return new EconomyServiceImpl(economyManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get EconomyService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public MarketService getMarketService() {
        try {
            MarketManager marketManager = this.plugin.getServiceRegistry().getInstance(MarketManager.class);
            return new MarketServiceImpl(marketManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get MarketService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public BankingService getBankingService() {
        try {
            BankManager bankManager = this.plugin.getServiceRegistry().getInstance(BankManager.class);
            return new BankingServiceImpl(bankManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get BankingService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public LoanService getLoanService() {
        try {
            LoanManager loanManager = this.plugin.getServiceRegistry().getInstance(LoanManager.class);
            return new LoanServiceImpl(loanManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get LoanService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public EventsService getEventsService() {
        try {
            EconomicEventEngine eventEngine = this.plugin.getServiceRegistry().getInstance(EconomicEventEngine.class);
            return new EventsServiceImpl(eventEngine);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get EventsService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public ProfessionService getProfessionService() {
        try {
            ProfessionsManager professionsManager = this.plugin.getServiceRegistry().getInstance(ProfessionsManager.class);
            return new ProfessionServiceImpl(professionsManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get ProfessionService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public InflationService getInflationService() {
        try {
            InflationManager inflationManager = this.plugin.getServiceRegistry().getInstance(InflationManager.class);
            DataManager dataManager = this.plugin.getServiceRegistry().getInstance(DataManager.class);
            return new InflationServiceImpl(inflationManager, dataManager);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get InflationService: " + e.getMessage());
            return null;
        }
    }

    @Override
    public ServerEconomySnapshot getServerEconomics() {
        try {
            ServiceRegistry sr = this.plugin.getServiceRegistry();
            InflationManager inflationManager = sr.getInstance(InflationManager.class);
            MarketManager marketManager = sr.getInstance(MarketManager.class);
            EconomicEventEngine eventEngine = sr.getInstance(EconomicEventEngine.class);
            double health = inflationManager.getEconomicHealth();
            double inflRate = inflationManager.getInflationRate();
            EconomicIntelligenceEngine.EconomicCycle cycle = inflationManager.getCurrentCycle();
            double activity = 0.0;
            try {
                MarketStatistics stats = marketManager.getMarketStatistics().join();
                activity = stats.getMarketActivity();
            }
            catch (Exception stats) {
                // empty catch block
            }
            int activeEvents = 0;
            try {
                activeEvents = eventEngine.getActiveEventsCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ServerEconomySnapshot(cycle != null ? cycle.name() : "UNKNOWN", health, inflRate, activity, activeEvents);
        }
        catch (Exception e) {
            return new ServerEconomySnapshot("UNKNOWN", 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public CycleForecast forecastCycle(Duration horizon) {
        try {
            ServiceRegistry sr = this.plugin.getServiceRegistry();
            InflationManager inflationManager = sr.getInstance(InflationManager.class);
            ConfigManager configManager = sr.getInstance(ConfigManager.class);
            FileConfiguration cfg = configManager.getModuleConfig("inflation");
            double targetInfl = cfg.getDouble("targets.inflation", 1.02);
            EconomicMemory.EconomicForecast forecast = inflationManager.getEconomicForecast();
            if (forecast == null) {
                return new CycleForecast(EconomicIntelligenceEngine.EconomicCycle.STABLE, 0.5, horizon);
            }
            double health = forecast.getPredictedHealth();
            double inflRate = forecast.getPredictedInflation();
            double confidence = forecast.getConfidence();
            EconomicIntelligenceEngine.EconomicCycle cycle = this.classifyCycle(health, inflRate, targetInfl);
            return new CycleForecast(cycle, confidence, horizon);
        }
        catch (Exception e) {
            return new CycleForecast(EconomicIntelligenceEngine.EconomicCycle.STABLE, 0.0, horizon);
        }
    }

    @Override
    public PlayerEconomyView getPlayerEconomyView(UUID playerId) {
        try {
            ServiceRegistry sr = this.plugin.getServiceRegistry();
            EconomyManager economyManager = sr.getInstance(EconomyManager.class);
            InflationManager inflationManager = sr.getInstance(InflationManager.class);
            DataManager dataManager = sr.getInstance(DataManager.class);
            BigDecimal balance = economyManager.getBalance(playerId).join();
            if (balance == null) {
                balance = BigDecimal.ZERO;
            }
            double percentile = 0.0;
            try (QueryResult qr2 = dataManager.executeQuery("SELECT COUNT(*) AS t, SUM(CASE WHEN balance <= ? THEN 1 ELSE 0 END) AS le FROM ecoxpert_accounts", balance).join();){
                if (qr2.next()) {
                    Long tl;
                    int total = 0;
                    int lessOrEqual = 0;
                    Integer ti = qr2.getInt("t");
                    total = ti != null ? ti : ((tl = qr2.getLong("t")) != null ? tl.intValue() : 0);
                    Integer lei = qr2.getInt("le");
                    if (lei != null) {
                        lessOrEqual = lei;
                    } else {
                        Long lel = qr2.getLong("le");
                        int n = lessOrEqual = lel != null ? lel.intValue() : 0;
                    }
                    if (total > 0) {
                        percentile = Math.max(0.0, Math.min(1.0, (double)lessOrEqual / (double)total));
                    }
                }
            }
            catch (Exception qr2) {
                // empty catch block
            }
            PlayerEconomicProfile profile = inflationManager.getPlayerProfile(playerId);
            double risk = profile != null ? profile.getRiskScore() : 0.5;
            double futureBalance = profile != null ? profile.getPredictedFutureBalance() : balance.doubleValue();
            return new PlayerEconomyView(playerId, balance, percentile, risk, futureBalance);
        }
        catch (Exception e) {
            return new PlayerEconomyView(playerId, BigDecimal.ZERO, 0.0, 0.5, 0.0);
        }
    }

    private EconomicIntelligenceEngine.EconomicCycle classifyCycle(double health, double inflRate, double targetInfl) {
        if (health >= 0.85) {
            if (inflRate >= targetInfl + 0.05) {
                return EconomicIntelligenceEngine.EconomicCycle.BUBBLE;
            }
            if (inflRate >= targetInfl + 0.01) {
                return EconomicIntelligenceEngine.EconomicCycle.BOOM;
            }
            return EconomicIntelligenceEngine.EconomicCycle.GROWTH;
        }
        if (health >= 0.6) {
            if (inflRate >= targetInfl + 0.03) {
                return EconomicIntelligenceEngine.EconomicCycle.BOOM;
            }
            if (inflRate <= targetInfl - 0.03) {
                return EconomicIntelligenceEngine.EconomicCycle.RECESSION;
            }
            return EconomicIntelligenceEngine.EconomicCycle.STABLE;
        }
        if (health >= 0.4) {
            if (inflRate <= targetInfl - 0.05) {
                return EconomicIntelligenceEngine.EconomicCycle.RECESSION;
            }
            return EconomicIntelligenceEngine.EconomicCycle.RECESSION;
        }
        if (inflRate <= targetInfl - 0.08) {
            return EconomicIntelligenceEngine.EconomicCycle.DEPRESSION;
        }
        return EconomicIntelligenceEngine.EconomicCycle.RECESSION;
    }
}

