/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.EconomyService;
import me.koyere.ecoxpert.api.dto.TransactionResult;
import me.koyere.ecoxpert.economy.EconomyManager;

public class EconomyServiceImpl
implements EconomyService {
    private final EconomyManager economyManager;

    public EconomyServiceImpl(EconomyManager economyManager) {
        this.economyManager = economyManager;
    }

    @Override
    public CompletableFuture<BigDecimal> getBalance(UUID playerId) {
        return this.economyManager.getBalance(playerId);
    }

    @Override
    public CompletableFuture<Boolean> hasAccount(UUID playerId) {
        return this.economyManager.hasAccount(playerId);
    }

    @Override
    public CompletableFuture<TransactionResult> deposit(UUID playerId, BigDecimal amount, String reason) {
        return ((CompletableFuture)((CompletableFuture)this.economyManager.addMoney(playerId, amount, reason).thenCompose(v -> this.economyManager.getBalance(playerId))).thenApply(newBalance -> new TransactionResult(true, "Deposit successful", (BigDecimal)newBalance))).exceptionally(ex -> new TransactionResult(false, "Deposit failed: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<TransactionResult> withdraw(UUID playerId, BigDecimal amount, String reason) {
        return ((CompletableFuture)this.economyManager.removeMoney(playerId, amount, reason).thenCompose(success -> {
            if (success.booleanValue()) {
                return this.economyManager.getBalance(playerId).thenApply(newBalance -> new TransactionResult(true, "Withdrawal successful", (BigDecimal)newBalance));
            }
            return CompletableFuture.completedFuture(new TransactionResult(false, "Insufficient funds", BigDecimal.ZERO));
        })).exceptionally(ex -> new TransactionResult(false, "Withdrawal failed: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<TransactionResult> transfer(UUID from, UUID to, BigDecimal amount, String reason) {
        return ((CompletableFuture)this.economyManager.transferMoney(from, to, amount, reason).thenCompose(success -> {
            if (success.booleanValue()) {
                return this.economyManager.getBalance(from).thenApply(newBalance -> new TransactionResult(true, "Transfer successful", (BigDecimal)newBalance));
            }
            return CompletableFuture.completedFuture(new TransactionResult(false, "Transfer failed", BigDecimal.ZERO));
        })).exceptionally(ex -> new TransactionResult(false, "Transfer failed: " + ex.getMessage(), BigDecimal.ZERO));
    }

    @Override
    public String formatCurrency(BigDecimal amount) {
        return this.economyManager.formatMoney(amount);
    }
}

