/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.api.services;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.api.LoanService;
import me.koyere.ecoxpert.api.dto.LoanInfo;
import me.koyere.ecoxpert.api.dto.LoanOfferInfo;
import me.koyere.ecoxpert.api.dto.LoanStatusInfo;
import me.koyere.ecoxpert.api.dto.PaymentStatus;
import me.koyere.ecoxpert.modules.loans.Loan;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanPayment;

public class LoanServiceImpl
implements LoanService {
    private final LoanManager loanManager;

    public LoanServiceImpl(LoanManager loanManager) {
        this.loanManager = loanManager;
    }

    @Override
    public CompletableFuture<LoanOfferInfo> getSmartOffer(UUID playerId) {
        return ((CompletableFuture)this.loanManager.getOffer(playerId, BigDecimal.ZERO).thenApply(offer -> new LoanOfferInfo(offer.amount(), offer.interestRate().doubleValue(), offer.termDays(), offer.score(), offer.reason()))).exceptionally(ex -> new LoanOfferInfo(BigDecimal.ZERO, 0.0, 0, 300, "UNKNOWN"));
    }

    @Override
    public CompletableFuture<LoanInfo> requestLoan(UUID playerId, BigDecimal amount) {
        return ((CompletableFuture)this.loanManager.requestLoanSmart(playerId, amount).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.loanManager.getActiveLoan(playerId).thenApply(optLoan -> {
                if (optLoan.isEmpty()) {
                    return null;
                }
                Loan loan = (Loan)optLoan.get();
                UUID loanId = UUID.nameUUIDFromBytes(("loan-" + loan.getId()).getBytes());
                Instant issuedAt = loan.getCreatedAt().atZone(ZoneId.systemDefault()).toInstant();
                Instant dueDate = issuedAt.plus(Duration.ofDays(30L));
                return new LoanInfo(loanId, loan.getPlayerUuid(), loan.getPrincipal(), loan.getOutstanding(), loan.getInterestRate().doubleValue(), issuedAt, dueDate, loan.getStatus());
            });
        })).exceptionally(ex -> null);
    }

    @Override
    public CompletableFuture<PaymentStatus> payLoan(UUID playerId, BigDecimal amount) {
        return ((CompletableFuture)this.loanManager.payLoan(playerId, amount).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(new PaymentStatus(false, "Payment failed", BigDecimal.ZERO, BigDecimal.ZERO));
            }
            return this.loanManager.getActiveLoan(playerId).thenApply(optLoan -> {
                BigDecimal remaining = optLoan.map(Loan::getOutstanding).orElse(BigDecimal.ZERO);
                return new PaymentStatus(true, "Payment successful", remaining, amount);
            });
        })).exceptionally(ex -> new PaymentStatus(false, "Payment failed: " + ex.getMessage(), BigDecimal.ZERO, BigDecimal.ZERO));
    }

    @Override
    public CompletableFuture<LoanStatusInfo> getStatus(UUID playerId) {
        return ((CompletableFuture)this.loanManager.getActiveLoan(playerId).thenCompose(optLoan -> {
            if (optLoan.isEmpty()) {
                return CompletableFuture.completedFuture(new LoanStatusInfo(false, BigDecimal.ZERO, null, BigDecimal.ZERO, 0));
            }
            Loan loan = (Loan)optLoan.get();
            return this.loanManager.getSchedule(playerId).thenApply(schedule -> {
                List<LoanPayment> pendingPayments = schedule.stream().filter(p -> "PENDING".equals(p.status())).toList();
                Optional nextPayment = pendingPayments.stream().findFirst();
                Instant nextPaymentInstant = nextPayment.map(p -> p.dueDate().atStartOfDay(ZoneId.systemDefault()).toInstant()).orElse(null);
                return new LoanStatusInfo(true, loan.getOutstanding(), nextPaymentInstant, nextPayment.map(p -> p.amountDue()).orElse(BigDecimal.ZERO), pendingPayments.size());
            });
        })).exceptionally(ex -> new LoanStatusInfo(false, BigDecimal.ZERO, null, BigDecimal.ZERO, 0));
    }

    @Override
    public CompletableFuture<Integer> getCreditScore(UUID playerId) {
        return ((CompletableFuture)this.loanManager.getOffer(playerId, BigDecimal.ZERO).thenApply(offer -> offer.score())).exceptionally(ex -> 300);
    }
}

