/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.commands;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.safety.RateLimitManager;
import me.koyere.ecoxpert.core.safety.SafeModeManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.events.EconomicEvent;
import me.koyere.ecoxpert.modules.events.EconomicEventEngine;
import me.koyere.ecoxpert.modules.market.MarketGUI;
import me.koyere.ecoxpert.modules.market.MarketItem;
import me.koyere.ecoxpert.modules.market.MarketManager;
import me.koyere.ecoxpert.modules.market.MarketStatistics;
import me.koyere.ecoxpert.modules.market.MarketTransactionResult;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderService;
import me.koyere.ecoxpert.modules.market.orders.MarketOrdersGUI;
import me.koyere.ecoxpert.modules.professions.ProfessionRole;
import me.koyere.ecoxpert.modules.professions.ProfessionsManager;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MarketCommand
implements TabExecutor {
    private final MarketManager marketManager;
    private final TranslationManager translationManager;
    private final Logger logger;
    private final MarketGUI marketGUI;
    private final MarketOrderService orderService;
    private final MarketOrdersGUI ordersGUI;

    public MarketCommand(MarketManager marketManager, TranslationManager translationManager, Logger logger) {
        this.marketManager = marketManager;
        this.translationManager = translationManager;
        this.logger = logger;
        this.marketGUI = new MarketGUI(marketManager, translationManager, logger);
        this.orderService = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(MarketOrderService.class);
        this.ordersGUI = new MarketOrdersGUI(this.orderService, translationManager, logger);
    }

    public MarketGUI getMarketGUI() {
        return this.marketGUI;
    }

    public MarketOrdersGUI getOrdersGUI() {
        return this.ordersGUI;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subcommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.translationManager.getMessage("player-only", new Object[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!this.marketManager.isMarketOpen()) {
            player.sendMessage(this.translationManager.getMessage("market.market-closed", new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.openMarketGUI(player);
            return true;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "buy": {
                return this.handleBuyCommand(player, args);
            }
            case "sell": {
                return this.handleSellCommand(player, args);
            }
            case "prices": {
                return this.handlePricesCommand(player, args);
            }
            case "stats": {
                return this.handleStatsCommand(player);
            }
            case "list": {
                return this.handleOrderListCreate(player, args);
            }
            case "orders": {
                return this.handleOrderListShow(player, args);
            }
            case "buyorder": {
                return this.handleOrderBuy(player, args);
            }
            case "help": {
                return this.handleHelpCommand(player);
            }
        }
        player.sendMessage(this.translationManager.getMessage("market.unknown-command", subcommand, new Object[0]));
        return true;
    }

    private boolean handleOrderListCreate(Player player, String[] args) {
        BigDecimal unit;
        int qty;
        Material mat;
        if (!player.hasPermission("ecoxpert.market.list")) {
            player.sendMessage(this.translationManager.getMessage("no-permission", new Object[0]));
            return true;
        }
        if (args.length < 4) {
            player.sendMessage(this.translationManager.getMessage("market.order.list-usage", new Object[0]));
            return true;
        }
        int hours = 48;
        try {
            mat = Material.valueOf((String)args[1].toUpperCase());
        }
        catch (Exception e) {
            player.sendMessage(this.translationManager.getMessage("market.invalid-item", args[1], new Object[0]));
            return true;
        }
        try {
            qty = Integer.parseInt(args[2]);
            if (qty <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (Exception e) {
            player.sendMessage(this.translationManager.getMessage("market.invalid-quantity", new Object[0]));
            return true;
        }
        try {
            unit = new BigDecimal(args[3]);
            if (unit.signum() <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (Exception e) {
            player.sendMessage(this.translationManager.getMessage("market.order.invalid", new Object[0]));
            return true;
        }
        if (args.length >= 5) {
            try {
                hours = Integer.parseInt(args[4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.orderService.createListing(player, mat, qty, unit, hours).thenAccept(msg -> player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + msg));
        return true;
    }

    private boolean handleOrderListShow(Player player, String[] args) {
        if (!player.hasPermission("ecoxpert.market.orders")) {
            player.sendMessage(this.translationManager.getMessage("no-permission", new Object[0]));
            return true;
        }
        Material filter = null;
        if (args.length >= 2) {
            try {
                filter = Material.valueOf((String)args[1].toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ordersGUI.open(player, filter);
        return true;
    }

    private boolean handleOrderBuy(Player player, String[] args) {
        int qty;
        long id;
        if (!player.hasPermission("ecoxpert.market.buyorder")) {
            player.sendMessage(this.translationManager.getMessage("no-permission", new Object[0]));
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(this.translationManager.getMessage("market.order.buy-usage", new Object[0]));
            return true;
        }
        try {
            id = Long.parseLong(args[1]);
            qty = Integer.parseInt(args[2]);
            if (qty <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (Exception e) {
            player.sendMessage(this.translationManager.getMessage("market.order.buy-usage", new Object[0]));
            return true;
        }
        this.orderService.buyFromOrder(player, id, qty).thenAccept(msg -> player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + msg));
        return true;
    }

    private String economyFormat(BigDecimal amount) {
        EconomyManager eco = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(EconomyManager.class);
        return eco.formatMoney(amount);
    }

    private boolean handleBuyCommand(Player player, String[] args) {
        Material material;
        SafeModeManager safe = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(SafeModeManager.class);
        if (safe != null && safe.isActive()) {
            player.sendMessage(this.translationManager.getMessage("market.error.safe-mode", new Object[0]));
            return true;
        }
        RateLimitManager limiter = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(RateLimitManager.class);
        if (limiter != null && !limiter.allow(player.getUniqueId(), "market.buy")) {
            player.sendMessage(this.translationManager.getMessage("errors.rate_limited", new Object[0]));
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.translationManager.getMessage("market.buy-usage", new Object[0]));
            return true;
        }
        try {
            material = Material.valueOf((String)args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.translationManager.getMessage("market.invalid-item", args[1], new Object[0]));
            return true;
        }
        int quantity = 1;
        if (args.length >= 3) {
            try {
                quantity = Integer.parseInt(args[2]);
                if (quantity <= 0) {
                    player.sendMessage(this.translationManager.getMessage("market.invalid-quantity", new Object[0]));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.translationManager.getMessage("market.invalid-quantity", new Object[0]));
                return true;
            }
        }
        CompletableFuture<MarketTransactionResult> buyFuture = this.marketManager.buyItem(player, material, quantity);
        buyFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Error processing buy command", (Throwable)throwable);
                player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                return;
            }
            if (result.isSuccess()) {
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            } else {
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            }
        });
        return true;
    }

    private boolean handleSellCommand(Player player, String[] args) {
        int quantity;
        Material material;
        block19: {
            SafeModeManager safe = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(SafeModeManager.class);
            if (safe != null && safe.isActive()) {
                player.sendMessage(this.translationManager.getMessage("market.error.safe-mode", new Object[0]));
                return true;
            }
            RateLimitManager limiter = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(RateLimitManager.class);
            if (limiter != null && !limiter.allow(player.getUniqueId(), "market.sell")) {
                player.sendMessage(this.translationManager.getMessage("errors.rate_limited", new Object[0]));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(this.translationManager.getMessage("market.sell-usage", new Object[0]));
                return true;
            }
            material = null;
            BigDecimal targetAmount = null;
            try {
                targetAmount = new BigDecimal(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (targetAmount != null) {
                Material material2 = material = player.getInventory().getItemInMainHand() != null ? player.getInventory().getItemInMainHand().getType() : null;
                if (material == null || material == Material.AIR) {
                    player.sendMessage(this.translationManager.getMessage("market.invalid-item", "hand", new Object[0]));
                    return true;
                }
            } else {
                try {
                    material = Material.valueOf((String)args[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(this.translationManager.getMessage("market.invalid-item", args[1], new Object[0]));
                    return true;
                }
            }
            if (targetAmount != null) {
                BigDecimal price = this.marketManager.getSellPrice(material).join();
                if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
                    player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                    return true;
                }
                quantity = targetAmount.divide(price, 0, 1).intValue();
                if (quantity <= 0) {
                    quantity = 1;
                }
            } else {
                if (args.length >= 3) {
                    try {
                        quantity = Integer.parseInt(args[2]);
                        if (quantity <= 0) {
                            player.sendMessage(this.translationManager.getMessage("market.invalid-quantity", new Object[0]));
                            return true;
                        }
                        break block19;
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(this.translationManager.getMessage("market.invalid-quantity", new Object[0]));
                        return true;
                    }
                }
                quantity = this.marketManager.countItems(player, material);
                if (quantity <= 0) {
                    player.sendMessage(this.translationManager.getMessage("market.no-items-to-sell", material.name().toLowerCase().replace('_', ' '), new Object[0]));
                    return true;
                }
            }
        }
        CompletableFuture<MarketTransactionResult> sellFuture = this.marketManager.sellItem(player, material, quantity);
        sellFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Error processing sell command", (Throwable)throwable);
                player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                return;
            }
            if (result.isSuccess()) {
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            } else {
                player.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + result.getMessage());
            }
        });
        return true;
    }

    private boolean handlePricesCommand(Player player, String[] args) {
        if (args.length >= 2) {
            Material material;
            try {
                material = Material.valueOf((String)args[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(this.translationManager.getMessage("market.invalid-item", args[1], new Object[0]));
                return true;
            }
            this.showItemPrices(player, material);
        } else {
            this.showMarketPrices(player);
        }
        return true;
    }

    private boolean handleStatsCommand(Player player) {
        CompletableFuture<MarketStatistics> statsFuture = this.marketManager.getMarketStatistics();
        statsFuture.whenComplete((stats, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Error getting market statistics", (Throwable)throwable);
                player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                return;
            }
            this.displayMarketStatistics(player, (MarketStatistics)stats);
        });
        return true;
    }

    private boolean handleHelpCommand(Player player) {
        player.sendMessage(this.translationManager.getMessage("market.help.header", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.buy", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.sell", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.prices", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.stats", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.list", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.orders", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.buyorder", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.gui", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.help.footer", new Object[0]));
        return true;
    }

    private void openMarketGUI(Player player) {
        this.marketGUI.openMarketGUI(player);
    }

    private void showItemPrices(Player player, Material material) {
        CompletableFuture<Optional<MarketItem>> itemFuture = this.marketManager.getItem(material);
        itemFuture.whenComplete((itemOpt, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Error getting item prices", (Throwable)throwable);
                player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                return;
            }
            if (itemOpt.isEmpty()) {
                player.sendMessage(this.translationManager.getMessage("market.item-not-found", material.name().toLowerCase().replace('_', ' '), new Object[0]));
                return;
            }
            MarketItem item = (MarketItem)itemOpt.get();
            String itemName = material.name().toLowerCase().replace('_', ' ');
            player.sendMessage(this.translationManager.getMessage("market.item-prices.header", itemName, new Object[0]));
            if (item.isBuyable()) {
                player.sendMessage(this.translationManager.getMessage("market.item-prices.buy", this.formatPrice(item.getCurrentBuyPrice()), new Object[0]));
                double f = this.computeEffectiveFactor(player.getUniqueId(), material, true);
                BigDecimal eff = item.getCurrentBuyPrice().multiply(BigDecimal.valueOf(f)).setScale(2, RoundingMode.HALF_UP);
                player.sendMessage(this.translationManager.getMessage("market.gui.item.effective-buy", this.formatPrice(eff), new Object[0]));
            }
            if (item.isSellable()) {
                player.sendMessage(this.translationManager.getMessage("market.item-prices.sell", this.formatPrice(item.getCurrentSellPrice()), new Object[0]));
                double f2 = this.computeEffectiveFactor(player.getUniqueId(), material, false);
                BigDecimal eff2 = item.getCurrentSellPrice().multiply(BigDecimal.valueOf(f2)).setScale(2, RoundingMode.HALF_UP);
                player.sendMessage(this.translationManager.getMessage("market.gui.item.effective-sell", this.formatPrice(eff2), new Object[0]));
            }
            player.sendMessage(this.translationManager.getMessage("market.item-prices.volume", item.getTotalVolume()));
            this.marketManager.getItemTrend(material).whenComplete((trend, trendThrowable) -> {
                if (trendThrowable == null && trend != null) {
                    player.sendMessage(this.translationManager.getMessage("market.item-prices.trend", trend.getDirection().getDisplayName(), this.formatPercentage(trend.getPriceChangePercentage())));
                }
            });
        });
    }

    private double computeEffectiveFactor(UUID uuid, Material material, boolean isBuy) {
        try {
            EconomicEventEngine events;
            ServiceRegistry sr = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry();
            ProfessionsManager pm = sr.getInstance(ProfessionsManager.class);
            Optional<ProfessionRole> roleOpt = pm.getRole(uuid).join();
            if (roleOpt.isEmpty()) {
                return 1.0;
            }
            String role = roleOpt.get().name().toLowerCase();
            FileConfiguration profCfg = sr.getInstance(ConfigManager.class).getModuleConfig("professions");
            int level = pm.getLevel(uuid).join();
            int maxLevel = profCfg.getInt("max_level", 5);
            level = Math.max(1, Math.min(level, maxLevel));
            double base = profCfg.getDouble("roles." + role + "." + (isBuy ? "buy_factor" : "sell_factor"), 1.0);
            double per = profCfg.getDouble("roles." + role + "." + (isBuy ? "buy_bonus_per_level" : "sell_bonus_per_level"), 0.0);
            double v = isBuy ? base * (1.0 - per * (double)(level - 1)) : base * (1.0 + per * (double)(level - 1));
            FileConfiguration cfg = sr.getInstance(ConfigManager.class).getModuleConfig("market");
            ConfigurationSection section = cfg.getConfigurationSection("categories");
            if (section != null) {
                block2: for (String key : section.getKeys(false)) {
                    List mats = cfg.getStringList("categories." + key + ".materials");
                    for (String m : mats) {
                        if (!material.name().equalsIgnoreCase(m)) continue;
                        String ck = "roles." + role + ".category_bonuses." + key.toLowerCase() + "." + (isBuy ? "buy_factor" : "sell_factor");
                        v *= profCfg.getDouble(ck, 1.0);
                        continue block2;
                    }
                }
            }
            if ((events = sr.getInstance(EconomicEventEngine.class)) != null) {
                for (EconomicEvent ev : events.getActiveEvents().values()) {
                    String ek = "roles." + role + ".event_bonuses." + ev.getType().name() + "." + (isBuy ? "buy_factor" : "sell_factor");
                    v *= profCfg.getDouble(ek, 1.0);
                }
            }
            if (v < 0.5) {
                v = 0.5;
            }
            if (v > 1.5) {
                v = 1.5;
            }
            return v;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private void showMarketPrices(Player player) {
        CompletableFuture<List<MarketItem>> itemsFuture = this.marketManager.getAllItems();
        itemsFuture.whenComplete((items, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Error getting market prices", (Throwable)throwable);
                player.sendMessage(this.translationManager.getMessage("market.system-error", new Object[0]));
                return;
            }
            player.sendMessage(this.translationManager.getMessage("market.prices-header", new Object[0]));
            int count = 0;
            for (MarketItem item : items) {
                if (count >= 10) break;
                if (!item.isActivelyTraded()) continue;
                String itemName = item.getMaterial().name().toLowerCase().replace('_', ' ');
                String buyPrice = item.isBuyable() ? this.formatPrice(item.getCurrentBuyPrice()) : "N/A";
                String sellPrice = item.isSellable() ? this.formatPrice(item.getCurrentSellPrice()) : "N/A";
                player.sendMessage(this.translationManager.getMessage("market.price-format", itemName, buyPrice, sellPrice));
                ++count;
            }
            if (items.size() > 10) {
                player.sendMessage(this.translationManager.getMessage("market.prices-more", items.size() - 10));
            }
        });
    }

    private void displayMarketStatistics(Player player, MarketStatistics stats) {
        player.sendMessage(this.translationManager.getMessage("market.stats.header", new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.stats.items", stats.getActiveItems(), stats.getTotalItems()));
        player.sendMessage(this.translationManager.getMessage("market.stats.transactions", stats.getTotalTransactions()));
        player.sendMessage(this.translationManager.getMessage("market.stats.volume", this.formatPrice(stats.getTotalVolume()), new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.stats.activity", stats.getActivityLevel(), new Object[0]));
        player.sendMessage(this.translationManager.getMessage("market.stats.daily", stats.getDailyTransactions(), this.formatPrice(stats.getDailyVolume())));
    }

    private String formatPrice(BigDecimal price) {
        return "$" + price.setScale(2, 4).toString();
    }

    private String formatPercentage(BigDecimal percentage) {
        String sign = percentage.compareTo(BigDecimal.ZERO) >= 0 ? "+" : "";
        return sign + String.valueOf(percentage.setScale(1, 4)) + "%";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block5: {
            String subcommand;
            block6: {
                block4: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block4;
                    List<String> subcommands = Arrays.asList("buy", "sell", "prices", "stats", "orders", "list", "buyorder", "help");
                    for (String sub : subcommands) {
                        if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        completions.add(sub);
                    }
                    break block5;
                }
                if (args.length != 2) break block6;
                String subcommand2 = args[0].toLowerCase();
                if (!"buy".equals(subcommand2) && !"sell".equals(subcommand2) && !"prices".equals(subcommand2)) break block5;
                List<String> materials = Arrays.asList("DIAMOND", "IRON_INGOT", "GOLD_INGOT", "EMERALD", "COAL", "STONE", "COBBLESTONE", "DIRT", "SAND", "GRAVEL", "WHEAT", "BREAD", "APPLE", "COOKED_BEEF", "COOKED_PORKCHOP");
                for (String material : materials) {
                    if (!material.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    completions.add(material);
                }
                break block5;
            }
            if (args.length == 3 && ("buy".equals(subcommand = args[0].toLowerCase()) || "sell".equals(subcommand))) {
                List<String> quantities = Arrays.asList("1", "10", "32", "64");
                for (String qty : quantities) {
                    if (!qty.startsWith(args[2])) continue;
                    completions.add(qty);
                }
            }
        }
        return completions;
    }
}

