/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.data;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.core.data.DatabaseStatus;
import me.koyere.ecoxpert.core.data.DatabaseTransaction;
import me.koyere.ecoxpert.core.data.QueryResult;

public interface DataManager {
    public void initialize();

    public void shutdown();

    public boolean isConnected();

    public String getDatabaseType();

    public CompletableFuture<Integer> executeUpdate(String var1, Object ... var2);

    public CompletableFuture<QueryResult> executeQuery(String var1, Object ... var2);

    public CompletableFuture<int[]> executeBatch(String var1, Object[] ... var2);

    public CompletableFuture<DatabaseTransaction> beginTransaction();

    public void createTables();

    public boolean needsMigration();

    public CompletableFuture<Void> migrate();

    public boolean isHealthy();

    public CompletableFuture<Void> exportDatabase(Path var1);

    public CompletableFuture<Void> importDatabase(Path var1);

    public CompletableFuture<Boolean> switchToFallback(String var1);

    public DatabaseStatus getStatus();
}

