/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.dependencies;

import me.koyere.ecoxpert.core.dependencies.DependencyState;

public class DependencyResult {
    private final DependencyState state;
    private final String message;
    private final Throwable exception;
    private final boolean usingFallback;

    private DependencyResult(DependencyState state, String message, Throwable exception, boolean usingFallback) {
        this.state = state;
        this.message = message;
        this.exception = exception;
        this.usingFallback = usingFallback;
    }

    public static DependencyResult success(DependencyState state) {
        return new DependencyResult(state, "Success", null, false);
    }

    public static DependencyResult success(DependencyState state, String message) {
        return new DependencyResult(state, message, null, false);
    }

    public static DependencyResult failure(DependencyState state, String message) {
        return new DependencyResult(state, message, null, false);
    }

    public static DependencyResult failure(DependencyState state, String message, Throwable exception) {
        return new DependencyResult(state, message, exception, false);
    }

    public static DependencyResult fallback(String message) {
        return new DependencyResult(DependencyState.FALLBACK, message, null, true);
    }

    public DependencyState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isSuccess() {
        return this.state == DependencyState.LOADED || this.state == DependencyState.FALLBACK;
    }

    public boolean isUsingFallback() {
        return this.usingFallback;
    }

    public String toString() {
        return "DependencyResult{state=" + String.valueOf((Object)this.state) + ", message='" + this.message + "', usingFallback=" + this.usingFallback + "}";
    }
}

