/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.economy;

import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.economy.EconomyConflictDetector;
import me.koyere.ecoxpert.core.economy.EconomyModeManager;
import me.koyere.ecoxpert.core.economy.EconomySyncManager;
import me.koyere.ecoxpert.core.economy.EconomySystemTestRunner;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import net.milkbowl.vault.economy.Economy;

public class EconomyTakeoverSystem {
    private final EcoXpertPlugin plugin;
    private final EconomyManager economyManager;
    private final VaultEconomyProvider vaultProvider;
    private EconomyModeManager modeManager;
    private EconomyConflictDetector conflictDetector;
    private EconomySyncManager syncManager;
    private boolean initialized = false;
    private boolean active = false;

    public EconomyTakeoverSystem(EcoXpertPlugin plugin, EconomyManager economyManager, VaultEconomyProvider vaultProvider) {
        this.plugin = plugin;
        this.economyManager = economyManager;
        this.vaultProvider = vaultProvider;
    }

    public boolean initialize() {
        if (this.initialized) {
            this.plugin.getLogger().info("Economy Takeover System already initialized");
            return true;
        }
        try {
            Economy fallbackEconomy;
            this.plugin.getLogger().info("Initializing Economy Takeover System...");
            this.conflictDetector = new EconomyConflictDetector(this.plugin);
            this.modeManager = new EconomyModeManager(this.plugin, this.vaultProvider);
            boolean modeInitialized = this.modeManager.initialize();
            if (!modeInitialized) {
                this.plugin.getLogger().warning("Failed to initialize economy mode manager");
                return false;
            }
            if (this.modeManager.isCompatibilityMode() && (fallbackEconomy = this.modeManager.getFallbackEconomy()) != null) {
                this.syncManager = new EconomySyncManager(this.plugin, this.economyManager, fallbackEconomy);
                this.syncManager.startSync();
                this.plugin.getLogger().info("Economy synchronization enabled with " + fallbackEconomy.getClass().getSimpleName());
            }
            this.initialized = true;
            this.active = true;
            this.plugin.getLogger().info("\u2713 Economy Takeover System initialized successfully");
            this.plugin.getLogger().info("Mode: " + String.valueOf((Object)this.modeManager.getCurrentMode()));
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize Economy Takeover System: " + e.getMessage());
            return false;
        }
    }

    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            this.plugin.getLogger().info("Shutting down Economy Takeover System...");
            if (this.syncManager != null) {
                this.syncManager.stopSync();
                this.syncManager = null;
            }
            this.modeManager = null;
            this.conflictDetector = null;
            this.active = false;
            this.initialized = false;
            this.plugin.getLogger().info("Economy Takeover System shutdown complete");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during Economy Takeover System shutdown: " + e.getMessage());
        }
    }

    public SystemStatus getStatus() {
        if (!this.initialized) {
            return new SystemStatus(false, false, null, null, null, "Not initialized");
        }
        try {
            EconomyConflictDetector.EconomyProviderStatus providerStatus = this.conflictDetector.detectEconomyProvider();
            EconomyConflictDetector.InstalledEconomyPlugins installedPlugins = this.conflictDetector.detectInstalledEconomyPlugins();
            EconomySyncManager.SyncStatistics syncStats = this.syncManager != null ? this.syncManager.getStatistics() : null;
            return new SystemStatus(true, this.active, this.modeManager.getCurrentMode(), providerStatus, installedPlugins, syncStats != null ? syncStats.toString() : "No sync active");
        }
        catch (Exception e) {
            return new SystemStatus(true, false, null, null, null, "Error getting status: " + e.getMessage());
        }
    }

    public boolean forceMode(EconomyModeManager.EconomyMode mode) {
        if (!this.initialized) {
            this.plugin.getLogger().warning("Cannot force mode - system not initialized");
            return false;
        }
        this.plugin.getLogger().info("Admin forcing economy mode to: " + String.valueOf((Object)mode));
        this.plugin.getLogger().info("Mode forcing requested but not yet implemented");
        return false;
    }

    public int importBalances() {
        if (!this.initialized || this.syncManager == null) {
            this.plugin.getLogger().warning("Cannot import balances - sync manager not available");
            return 0;
        }
        try {
            return this.syncManager.importBalancesFromFallback().join();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error importing balances: " + e.getMessage());
            return 0;
        }
    }

    public String runDiagnostics() {
        if (!this.initialized) {
            return "Economy Takeover System not initialized";
        }
        EconomySystemTestRunner testRunner = new EconomySystemTestRunner(this.plugin);
        EconomySystemTestRunner.TestResults results = testRunner.runSafeTests();
        return results.toString();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return this.active;
    }

    public EconomyModeManager getModeManager() {
        return this.modeManager;
    }

    public EconomyConflictDetector getConflictDetector() {
        return this.conflictDetector;
    }

    public EconomySyncManager getSyncManager() {
        return this.syncManager;
    }

    public static class SystemStatus {
        private final boolean initialized;
        private final boolean active;
        private final EconomyModeManager.EconomyMode currentMode;
        private final EconomyConflictDetector.EconomyProviderStatus providerStatus;
        private final EconomyConflictDetector.InstalledEconomyPlugins installedPlugins;
        private final String additionalInfo;

        public SystemStatus(boolean initialized, boolean active, EconomyModeManager.EconomyMode currentMode, EconomyConflictDetector.EconomyProviderStatus providerStatus, EconomyConflictDetector.InstalledEconomyPlugins installedPlugins, String additionalInfo) {
            this.initialized = initialized;
            this.active = active;
            this.currentMode = currentMode;
            this.providerStatus = providerStatus;
            this.installedPlugins = installedPlugins;
            this.additionalInfo = additionalInfo;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isActive() {
            return this.active;
        }

        public EconomyModeManager.EconomyMode getCurrentMode() {
            return this.currentMode;
        }

        public EconomyConflictDetector.EconomyProviderStatus getProviderStatus() {
            return this.providerStatus;
        }

        public EconomyConflictDetector.InstalledEconomyPlugins getInstalledPlugins() {
            return this.installedPlugins;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("=== Economy Takeover System Status ===\n");
            sb.append("Initialized: ").append(this.initialized).append("\n");
            sb.append("Active: ").append(this.active).append("\n");
            sb.append("Current Mode: ").append((Object)this.currentMode).append("\n");
            if (this.providerStatus != null) {
                sb.append("Provider Status: ").append((Object)this.providerStatus.getStatus()).append("\n");
                sb.append("Active Provider: ").append(this.providerStatus.getPluginName()).append("\n");
            }
            if (this.installedPlugins != null) {
                sb.append("Installed Economy Plugins: ").append(this.installedPlugins.getInstalledCount()).append("\n");
                for (String plugin : this.installedPlugins.getInstalledPlugins()) {
                    sb.append("  - ").append(plugin).append("\n");
                }
            }
            sb.append("Additional Info: ").append(this.additionalInfo).append("\n");
            sb.append("=== End Status ===");
            return sb.toString();
        }
    }
}

