/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.failsafe;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.core.failsafe.FailsafeHealth;
import me.koyere.ecoxpert.core.failsafe.RepairResult;
import me.koyere.ecoxpert.core.failsafe.TransactionHistory;
import me.koyere.ecoxpert.core.failsafe.TransactionRecord;
import me.koyere.ecoxpert.core.failsafe.ValidationResult;

public interface EconomyFailsafeManager {
    public void initialize();

    public void shutdown();

    public CompletableFuture<Void> createBackup(String var1);

    public CompletableFuture<Void> restoreFromBackup();

    public CompletableFuture<Void> restoreFromBackup(String var1);

    public CompletableFuture<ValidationResult> performConsistencyCheck();

    public void enterReadOnlyMode(String var1);

    public void exitReadOnlyMode();

    public boolean isReadOnlyMode();

    public String getReadOnlyReason();

    public CompletableFuture<Void> recordTransaction(TransactionRecord var1);

    public CompletableFuture<TransactionHistory> getTransactionHistory(UUID var1, int var2);

    public CompletableFuture<RepairResult> detectAndRepairCorruption();

    public CompletableFuture<String> createCheckpoint(String var1);

    public CompletableFuture<Void> rollbackToCheckpoint(String var1);

    public CompletableFuture<Void> commitCheckpoint(String var1);

    public FailsafeHealth getHealthStatus();

    public CompletableFuture<FailsafeHealth> performHealthCheck();
}

