/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.failsafe;

import java.util.List;

public class ValidationResult {
    private final boolean valid;
    private final List<String> errors;
    private final List<String> warnings;
    private final ValidationSeverity severity;
    private final String summary;

    public ValidationResult(boolean valid, List<String> errors, List<String> warnings, ValidationSeverity severity, String summary) {
        this.valid = valid;
        this.errors = List.copyOf(errors);
        this.warnings = List.copyOf(warnings);
        this.severity = severity;
        this.summary = summary;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public ValidationSeverity getSeverity() {
        return this.severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public static enum ValidationSeverity {
        HEALTHY,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

