/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.platform;

import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.platform.PlatformManager;
import me.koyere.ecoxpert.core.platform.ServerPlatform;
import org.bukkit.Bukkit;

@Singleton
public class PlatformManagerImpl
implements PlatformManager {
    private final EcoXpertPlugin plugin;
    private ServerPlatform platform;
    private String platformName;
    private String minecraftVersion;
    private boolean geyserAvailable;

    @Inject
    public PlatformManagerImpl(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void detectPlatform() {
        this.platformName = Bukkit.getVersion();
        this.platform = ServerPlatform.fromServerName(this.platformName);
        this.minecraftVersion = Bukkit.getBukkitVersion().split("-")[0];
        this.geyserAvailable = this.plugin.getServer().getPluginManager().getPlugin("Geyser-Spigot") != null;
        this.plugin.getLogger().info("Detected platform: " + this.platform.getDisplayName() + " (MC " + this.minecraftVersion + ")");
        if (this.geyserAvailable) {
            this.plugin.getLogger().info("GeyserMC detected - Bedrock support available");
        }
        this.logCapabilities();
    }

    @Override
    public String getPlatformName() {
        return this.platform != null ? this.platform.getDisplayName() : "Unknown";
    }

    @Override
    public ServerPlatform getPlatform() {
        return this.platform != null ? this.platform : ServerPlatform.UNKNOWN;
    }

    @Override
    public boolean isPaperAvailable() {
        return this.platform != null && this.platform.isPaperCompatible();
    }

    @Override
    public boolean isFoliaAvailable() {
        return this.platform == ServerPlatform.FOLIA;
    }

    @Override
    public boolean isGeyserAvailable() {
        return this.geyserAvailable;
    }

    @Override
    public boolean hasBedrockPlayers() {
        if (!this.geyserAvailable) {
            return false;
        }
        return Bukkit.getOnlinePlayers().stream().anyMatch(player -> this.isBedrockPlayer(player.getUniqueId().toString()));
    }

    @Override
    public String getMinecraftVersion() {
        return this.minecraftVersion != null ? this.minecraftVersion : "Unknown";
    }

    @Override
    public boolean supportsAsyncScheduler() {
        return this.isPaperAvailable() && this.isVersionAtLeast("1.19.4");
    }

    @Override
    public boolean supportsAdventure() {
        return this.platform != null && this.platform.hasAdventureSupport();
    }

    private boolean isVersionAtLeast(String targetVersion) {
        if (this.minecraftVersion == null) {
            return false;
        }
        try {
            String[] current = this.minecraftVersion.split("\\.");
            String[] target = targetVersion.split("\\.");
            for (int i = 0; i < Math.max(current.length, target.length); ++i) {
                int targetPart;
                int currentPart = i < current.length ? Integer.parseInt(current[i]) : 0;
                int n = targetPart = i < target.length ? Integer.parseInt(target[i]) : 0;
                if (currentPart > targetPart) {
                    return true;
                }
                if (currentPart >= targetPart) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isBedrockPlayer(String uuid) {
        return uuid.startsWith("00000000");
    }

    private void logCapabilities() {
        this.plugin.getLogger().info("Platform capabilities:");
        this.plugin.getLogger().info("  Paper API: " + this.isPaperAvailable());
        this.plugin.getLogger().info("  Adventure API: " + this.supportsAdventure());
        this.plugin.getLogger().info("  Async Scheduler: " + this.supportsAsyncScheduler());
        this.plugin.getLogger().info("  Folia Threading: " + this.isFoliaAvailable());
        this.plugin.getLogger().info("  Bedrock Support: " + this.isGeyserAvailable());
    }
}

