/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.platform;

public enum ServerPlatform {
    SPIGOT("Spigot", false, false, false),
    PAPER("Paper", true, true, false),
    PURPUR("Purpur", true, true, false),
    FOLIA("Folia", true, true, true),
    UNKNOWN("Unknown", false, false, false);

    private final String displayName;
    private final boolean paperCompatible;
    private final boolean adventureSupport;
    private final boolean regionalThreading;

    private ServerPlatform(String displayName, boolean paperCompatible, boolean adventureSupport, boolean regionalThreading) {
        this.displayName = displayName;
        this.paperCompatible = paperCompatible;
        this.adventureSupport = adventureSupport;
        this.regionalThreading = regionalThreading;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isPaperCompatible() {
        return this.paperCompatible;
    }

    public boolean hasAdventureSupport() {
        return this.adventureSupport;
    }

    public boolean hasRegionalThreading() {
        return this.regionalThreading;
    }

    public static ServerPlatform fromServerName(String serverName) {
        if (serverName == null) {
            return UNKNOWN;
        }
        String name = serverName.toLowerCase();
        if (name.contains("folia")) {
            return FOLIA;
        }
        if (name.contains("purpur")) {
            return PURPUR;
        }
        if (name.contains("paper")) {
            return PAPER;
        }
        if (name.contains("spigot")) {
            return SPIGOT;
        }
        return UNKNOWN;
    }
}

