/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.translation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
public class TranslationManagerImpl
implements TranslationManager {
    private final EcoXpertPlugin plugin;
    private final ConfigManager configManager;
    private final Map<String, FileConfiguration> languageConfigs = new HashMap<String, FileConfiguration>();
    private final Map<UUID, String> playerLanguages = new HashMap<UUID, String>();
    private String defaultLanguage;

    @Inject
    public TranslationManagerImpl(EcoXpertPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    @Override
    public void initialize() {
        this.plugin.getLogger().info("Initializing translation system...");
        this.defaultLanguage = this.configManager.getLanguage();
        File languagesDir = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesDir.exists()) {
            languagesDir.mkdirs();
        }
        this.loadDefaultLanguageFiles();
        this.loadLanguageConfigurations();
        this.plugin.getLogger().info("Translation system initialized with " + this.languageConfigs.size() + " languages");
    }

    @Override
    public void reload() {
        this.languageConfigs.clear();
        this.playerLanguages.clear();
        this.defaultLanguage = this.configManager.getLanguage();
        this.loadLanguageConfigurations();
        this.plugin.getLogger().info("Translation system reloaded");
    }

    @Override
    public String getMessage(String key, Object ... args) {
        return this.getMessage(this.defaultLanguage, key, args);
    }

    @Override
    public String getMessage(String language, String key, Object ... args) {
        String message;
        FileConfiguration config;
        String[] parts;
        String lang = language;
        if (lang != null && lang.length() > 2 && (parts = lang.split("[-_]")).length > 0 && parts[0].length() == 2) {
            lang = parts[0].toLowerCase();
        }
        if ((config = this.languageConfigs.get(lang)) == null) {
            config = this.languageConfigs.get(this.defaultLanguage);
        }
        if (config == null) {
            config = this.languageConfigs.get("en");
        }
        String string = message = config != null ? config.getString(key) : null;
        if (message == null) {
            message = this.loadFromEmbedded(lang, key);
            if (message == null && !"en".equals(lang)) {
                message = this.loadFromEmbedded("en", key);
            }
            if (message == null) {
                message = key;
            }
        }
        return this.formatMessage(message, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadFromEmbedded(String language, String key) {
        try (InputStream in = this.plugin.getResource("languages/messages_" + language + ".yml");){
            if (in == null) {
                String string2 = null;
                return string2;
            }
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in));
            String string = cfg.getString(key);
            return string;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public String getPlayerMessage(Player player, String key, Object ... args) {
        String language = this.getPlayerLanguage(player);
        return this.getMessage(language, key, args);
    }

    @Override
    public void sendMessage(Player player, String key, Object ... args) {
        String message = this.getPlayerMessage(player, key, args);
        player.sendMessage(message);
    }

    @Override
    public void sendConsoleMessage(String key, Object ... args) {
        String message = this.getMessage(key, args);
        this.plugin.getLogger().info(message);
    }

    @Override
    public String[] getAvailableLanguages() {
        return this.languageConfigs.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isLanguageSupported(String language) {
        return this.languageConfigs.containsKey(language);
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public String getPlayerLanguage(Player player) {
        return this.playerLanguages.getOrDefault(player.getUniqueId(), this.defaultLanguage);
    }

    @Override
    public void setPlayerLanguage(Player player, String language) {
        if (this.isLanguageSupported(language)) {
            this.playerLanguages.put(player.getUniqueId(), language);
        }
    }

    private void loadDefaultLanguageFiles() {
        String[] languages;
        for (String lang : languages = new String[]{"en", "es"}) {
            String fileName = "messages_" + lang + ".yml";
            File langFile = new File(this.plugin.getDataFolder(), "languages/" + fileName);
            if (langFile.exists()) continue;
            try {
                InputStream resource = this.plugin.getResource("languages/" + fileName);
                if (resource != null) {
                    Files.copy(resource, langFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Created default language file: " + fileName);
                    continue;
                }
                this.createBasicLanguageFile(langFile, lang);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create language file: " + fileName);
                this.createBasicLanguageFile(langFile, lang);
            }
        }
    }

    private void createBasicLanguageFile(File file, String language) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if ("es".equals(language)) {
                config.set("prefix", (Object)"&8[&6EcoXpert&8] &f");
                config.set("plugin.enabled", (Object)"&aEcoXpert Pro habilitado correctamente");
                config.set("plugin.disabled", (Object)"&cEcoXpert Pro deshabilitado");
                config.set("error.no-permission", (Object)"&cNo tienes permisos para ejecutar este comando");
                config.set("error.player-only", (Object)"&cEste comando solo puede ser ejecutado por jugadores");
                config.set("admin.gui.title", (Object)"Panel Admin EcoXpert");
                config.set("admin.gui.events", (Object)"Eventos");
                config.set("admin.gui.market", (Object)"Mercado");
                config.set("admin.gui.loans", (Object)"Pr\u00e9stamos");
                config.set("admin.gui.economy", (Object)"Econom\u00eda");
            } else {
                config.set("prefix", (Object)"&8[&6EcoXpert&8] &f");
                config.set("plugin.enabled", (Object)"&aEcoXpert Pro enabled successfully");
                config.set("plugin.disabled", (Object)"&cEcoXpert Pro disabled");
                config.set("error.no-permission", (Object)"&cYou don't have permission to execute this command");
                config.set("error.player-only", (Object)"&cThis command can only be executed by players");
                config.set("admin.gui.title", (Object)"EcoXpert Admin");
                config.set("admin.gui.events", (Object)"Events");
                config.set("admin.gui.market", (Object)"Market");
                config.set("admin.gui.loans", (Object)"Loans");
                config.set("admin.gui.economy", (Object)"Economy");
            }
            config.save(file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create basic language file: " + file.getName());
        }
    }

    private void loadLanguageConfigurations() {
        File languagesDir = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesDir.exists()) {
            return;
        }
        File[] files = languagesDir.listFiles((dir, name) -> name.startsWith("messages_") && name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                String language = fileName.substring(9, fileName.length() - 4);
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                this.languageConfigs.put(language, (FileConfiguration)config);
                this.plugin.getLogger().info("Loaded language: " + language);
            }
        }
    }

    private String formatMessage(String message, Object ... args) {
        if (args.length == 0) {
            return message.replace('&', '\u00a7');
        }
        for (int i = 0; i < args.length; ++i) {
            message = message.replace("{" + i + "}", String.valueOf(args[i]));
        }
        return message.replace('&', '\u00a7');
    }
}

