/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import me.koyere.ecoxpert.modules.bank.BankAccountTier;

public class BankAccountSummary {
    private final UUID accountId;
    private final String accountNumber;
    private final BankAccountTier currentTier;
    private final BankAccountTier eligibleTier;
    private final BigDecimal currentBalance;
    private final boolean frozen;
    private final String frozenReason;
    private final LocalDateTime accountAge;
    private final BigDecimal totalInterestEarned;
    private final BigDecimal monthlyInterestEarned;
    private final BigDecimal projectedAnnualInterest;
    private final BigDecimal effectiveAPY;
    private final int totalTransactions;
    private final int monthlyTransactions;
    private final BigDecimal totalDeposited;
    private final BigDecimal totalWithdrawn;
    private final LocalDateTime lastActivity;
    private final BigDecimal dailyDepositRemaining;
    private final BigDecimal dailyWithdrawRemaining;
    private final BigDecimal dailyTransferRemaining;
    private final int failedTransactionCount;
    private final LocalDateTime lastFailedTransaction;
    private final boolean requiresAttention;
    private final LocalDateTime generatedAt;

    public BankAccountSummary(UUID accountId, String accountNumber, BankAccountTier currentTier, BankAccountTier eligibleTier, BigDecimal currentBalance, boolean frozen, String frozenReason, LocalDateTime accountAge, BigDecimal totalInterestEarned, BigDecimal monthlyInterestEarned, BigDecimal projectedAnnualInterest, BigDecimal effectiveAPY, int totalTransactions, int monthlyTransactions, BigDecimal totalDeposited, BigDecimal totalWithdrawn, LocalDateTime lastActivity, BigDecimal dailyDepositRemaining, BigDecimal dailyWithdrawRemaining, BigDecimal dailyTransferRemaining, int failedTransactionCount, LocalDateTime lastFailedTransaction, boolean requiresAttention) {
        this.accountId = accountId;
        this.accountNumber = accountNumber;
        this.currentTier = currentTier;
        this.eligibleTier = eligibleTier;
        this.currentBalance = currentBalance;
        this.frozen = frozen;
        this.frozenReason = frozenReason;
        this.accountAge = accountAge;
        this.totalInterestEarned = totalInterestEarned;
        this.monthlyInterestEarned = monthlyInterestEarned;
        this.projectedAnnualInterest = projectedAnnualInterest;
        this.effectiveAPY = effectiveAPY;
        this.totalTransactions = totalTransactions;
        this.monthlyTransactions = monthlyTransactions;
        this.totalDeposited = totalDeposited;
        this.totalWithdrawn = totalWithdrawn;
        this.lastActivity = lastActivity;
        this.dailyDepositRemaining = dailyDepositRemaining;
        this.dailyWithdrawRemaining = dailyWithdrawRemaining;
        this.dailyTransferRemaining = dailyTransferRemaining;
        this.failedTransactionCount = failedTransactionCount;
        this.lastFailedTransaction = lastFailedTransaction;
        this.requiresAttention = requiresAttention;
        this.generatedAt = LocalDateTime.now();
    }

    public boolean isEligibleForUpgrade() {
        return this.eligibleTier != null && this.eligibleTier != this.currentTier;
    }

    public long getAccountAgeInDays() {
        return ChronoUnit.DAYS.between(this.accountAge, LocalDateTime.now());
    }

    public long getDaysSinceLastActivity() {
        if (this.lastActivity == null) {
            return -1L;
        }
        return ChronoUnit.DAYS.between(this.lastActivity, LocalDateTime.now());
    }

    public boolean isActiveAccount() {
        return this.getDaysSinceLastActivity() <= 30L;
    }

    public int getAccountHealthScore() {
        long daysSinceActivity;
        int score = 100;
        if (this.frozen) {
            score -= 50;
        }
        if (this.failedTransactionCount > 0) {
            score -= Math.min(this.failedTransactionCount * 5, 25);
        }
        if ((daysSinceActivity = this.getDaysSinceLastActivity()) > 30L) {
            score = (int)((long)score - Math.min((daysSinceActivity - 30L) / 7L * 5L, 20L));
        }
        if (this.monthlyTransactions > 10) {
            score += 5;
        }
        return Math.max(0, Math.min(100, score));
    }

    public PerformanceRating getPerformanceRating() {
        int healthScore = this.getAccountHealthScore();
        if (healthScore >= 90) {
            return PerformanceRating.EXCELLENT;
        }
        if (healthScore >= 75) {
            return PerformanceRating.GOOD;
        }
        if (healthScore >= 60) {
            return PerformanceRating.FAIR;
        }
        if (healthScore >= 40) {
            return PerformanceRating.POOR;
        }
        return PerformanceRating.CRITICAL;
    }

    public BigDecimal getNetWorthGrowthRate() {
        if (this.totalDeposited.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal netGain = this.totalInterestEarned.add(this.currentBalance).subtract(this.totalDeposited);
        return netGain.divide(this.totalDeposited, 4, 4).multiply(new BigDecimal("100"));
    }

    public String getAccountOverview() {
        StringBuilder overview = new StringBuilder();
        overview.append("Account: ").append(this.accountNumber).append("\n");
        overview.append("Tier: ").append(this.currentTier.getDisplayName()).append("\n");
        overview.append("Balance: $").append(this.currentBalance).append("\n");
        overview.append("Interest Earned: $").append(this.totalInterestEarned).append("\n");
        overview.append("Health Score: ").append(this.getAccountHealthScore()).append("/100\n");
        overview.append("Performance: ").append(this.getPerformanceRating().getDisplayName());
        if (this.isEligibleForUpgrade()) {
            overview.append("\n\u2605 Eligible for ").append(this.eligibleTier.getDisplayName()).append(" upgrade!");
        }
        return overview.toString();
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public BankAccountTier getCurrentTier() {
        return this.currentTier;
    }

    public BankAccountTier getEligibleTier() {
        return this.eligibleTier;
    }

    public BigDecimal getCurrentBalance() {
        return this.currentBalance;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public String getFrozenReason() {
        return this.frozenReason;
    }

    public LocalDateTime getAccountAge() {
        return this.accountAge;
    }

    public BigDecimal getTotalInterestEarned() {
        return this.totalInterestEarned;
    }

    public BigDecimal getMonthlyInterestEarned() {
        return this.monthlyInterestEarned;
    }

    public BigDecimal getProjectedAnnualInterest() {
        return this.projectedAnnualInterest;
    }

    public BigDecimal getEffectiveAPY() {
        return this.effectiveAPY;
    }

    public int getTotalTransactions() {
        return this.totalTransactions;
    }

    public int getMonthlyTransactions() {
        return this.monthlyTransactions;
    }

    public BigDecimal getTotalDeposited() {
        return this.totalDeposited;
    }

    public BigDecimal getTotalWithdrawn() {
        return this.totalWithdrawn;
    }

    public LocalDateTime getLastActivity() {
        return this.lastActivity;
    }

    public BigDecimal getDailyDepositRemaining() {
        return this.dailyDepositRemaining;
    }

    public BigDecimal getDailyWithdrawRemaining() {
        return this.dailyWithdrawRemaining;
    }

    public BigDecimal getDailyTransferRemaining() {
        return this.dailyTransferRemaining;
    }

    public int getFailedTransactionCount() {
        return this.failedTransactionCount;
    }

    public LocalDateTime getLastFailedTransaction() {
        return this.lastFailedTransaction;
    }

    public boolean isRequiresAttention() {
        return this.requiresAttention;
    }

    public LocalDateTime getGeneratedAt() {
        return this.generatedAt;
    }

    public static enum PerformanceRating {
        EXCELLENT("Excellent", "\ud83c\udf1f"),
        GOOD("Good", "\u2705"),
        FAIR("Fair", "\u26a0\ufe0f"),
        POOR("Poor", "\u26a0\ufe0f"),
        CRITICAL("Critical", "\ud83d\udea8");

        private final String displayName;
        private final String emoji;

        private PerformanceRating(String displayName, String emoji) {
            this.displayName = displayName;
            this.emoji = emoji;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public String getFormattedName() {
            return this.emoji + " " + this.displayName;
        }
    }
}

