/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import me.koyere.ecoxpert.modules.bank.BankTransactionType;

public enum BankAccountTier {
    BASIC("Basic", new BigDecimal("0.01"), new BigDecimal("1000"), new BigDecimal("500"), new BigDecimal("250"), BigDecimal.ZERO),
    SILVER("Silver", new BigDecimal("0.015"), new BigDecimal("5000"), new BigDecimal("2500"), new BigDecimal("1000"), new BigDecimal("10000")),
    GOLD("Gold", new BigDecimal("0.02"), new BigDecimal("25000"), new BigDecimal("10000"), new BigDecimal("5000"), new BigDecimal("50000")),
    PLATINUM("Platinum", new BigDecimal("0.025"), new BigDecimal("100000"), new BigDecimal("50000"), new BigDecimal("25000"), new BigDecimal("250000"));

    private final String displayName;
    private final BigDecimal annualInterestRate;
    private final BigDecimal dailyDepositLimit;
    private final BigDecimal dailyWithdrawLimit;
    private final BigDecimal dailyTransferLimit;
    private final BigDecimal minimumBalance;

    private BankAccountTier(String displayName, BigDecimal annualInterestRate, BigDecimal dailyDepositLimit, BigDecimal dailyWithdrawLimit, BigDecimal dailyTransferLimit, BigDecimal minimumBalance) {
        this.displayName = displayName;
        this.annualInterestRate = annualInterestRate;
        this.dailyDepositLimit = dailyDepositLimit;
        this.dailyWithdrawLimit = dailyWithdrawLimit;
        this.dailyTransferLimit = dailyTransferLimit;
        this.minimumBalance = minimumBalance;
    }

    public BigDecimal getDailyInterestRate() {
        return this.annualInterestRate.divide(new BigDecimal("365"), 10, 4);
    }

    public BigDecimal getDailyLimit(BankTransactionType type) {
        return switch (type) {
            case BankTransactionType.DEPOSIT -> this.dailyDepositLimit;
            case BankTransactionType.WITHDRAW -> this.dailyWithdrawLimit;
            case BankTransactionType.TRANSFER_OUT -> this.dailyTransferLimit;
            default -> BigDecimal.ZERO;
        };
    }

    public boolean qualifiesForTier(BigDecimal balance) {
        return balance.compareTo(this.minimumBalance) >= 0;
    }

    public BankAccountTier getNextTier() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BASIC -> SILVER;
            case SILVER -> GOLD;
            case GOLD -> PLATINUM;
            case PLATINUM -> PLATINUM;
        };
    }

    public boolean canUpgrade() {
        return this != PLATINUM;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BigDecimal getAnnualInterestRate() {
        return this.annualInterestRate;
    }

    public BigDecimal getDailyDepositLimit() {
        return this.dailyDepositLimit;
    }

    public BigDecimal getDailyWithdrawLimit() {
        return this.dailyWithdrawLimit;
    }

    public BigDecimal getDailyTransferLimit() {
        return this.dailyTransferLimit;
    }

    public BigDecimal getMinimumBalance() {
        return this.minimumBalance;
    }
}

