/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.modules.bank.BankAccount;
import me.koyere.ecoxpert.modules.bank.BankAccountSummary;
import me.koyere.ecoxpert.modules.bank.BankAccountTier;
import me.koyere.ecoxpert.modules.bank.BankOperationResult;
import me.koyere.ecoxpert.modules.bank.BankStatement;
import me.koyere.ecoxpert.modules.bank.BankStatistics;
import me.koyere.ecoxpert.modules.bank.BankTransaction;
import me.koyere.ecoxpert.modules.bank.BankTransactionType;
import org.bukkit.entity.Player;

public interface BankManager {
    public CompletableFuture<Void> initialize();

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<BankAccount> getOrCreateAccount(UUID var1);

    public CompletableFuture<Optional<BankAccount>> getAccount(UUID var1);

    public CompletableFuture<Boolean> hasAccount(UUID var1);

    public CompletableFuture<BankAccountTier> getAccountTier(UUID var1);

    public CompletableFuture<BankOperationResult> upgradeAccountTier(UUID var1, BankAccountTier var2);

    public CompletableFuture<BankOperationResult> deposit(Player var1, BigDecimal var2);

    public CompletableFuture<BankOperationResult> withdraw(Player var1, BigDecimal var2);

    public CompletableFuture<BankOperationResult> transfer(Player var1, UUID var2, BigDecimal var3);

    public CompletableFuture<BigDecimal> getBalance(UUID var1);

    public CompletableFuture<BigDecimal> getDailyLimitRemaining(UUID var1, BankTransactionType var2);

    public CompletableFuture<BigDecimal> calculateInterest(UUID var1);

    public CompletableFuture<Void> processDailyInterest();

    public BigDecimal getInterestRate(BankAccountTier var1);

    public CompletableFuture<BigDecimal> getProjectedInterest(UUID var1, int var2);

    public CompletableFuture<List<BankTransaction>> getTransactionHistory(UUID var1, int var2);

    public CompletableFuture<List<BankTransaction>> getTransactionHistory(UUID var1, LocalDate var2, LocalDate var3);

    public CompletableFuture<BankStatement> getMonthlyStatement(UUID var1, int var2, int var3);

    public CompletableFuture<BankStatistics> getBankStatistics();

    public CompletableFuture<BankAccountSummary> getAccountSummary(UUID var1);

    public boolean isBankingAvailable();

    public CompletableFuture<BankOperationResult> forceInterestCalculation(UUID var1);

    public CompletableFuture<BankOperationResult> resetDailyLimits(UUID var1);

    public CompletableFuture<BankOperationResult> setAccountFrozen(UUID var1, boolean var2, String var3);
}

